/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.gpgverifier;

import com.adventnet.sym.server.gpgverifier.GPGSignatureVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class PatchGPGSignatureVerifier
implements GPGSignatureVerifier {
    private static final Logger LOGGER = LogManager.getLogger(PatchGPGSignatureVerifier.class);
    private static final String DEFAULT_KEYSERVER_URL = "https://keyserver.ubuntu.com/pks/lookup?op=get&search=0x";
    private String actualFilePath;
    private String signatureFilePath;
    private PGPSignatureList pgpSignatureList;

    public PatchGPGSignatureVerifier(String actualFilePath, String signatureFilePath) {
        this.actualFilePath = actualFilePath;
        this.signatureFilePath = signatureFilePath;
        this.loadSignature();
    }

    @Override
    public void loadSignature() {
        try {
            InputStream sigIn = PGPUtil.getDecoderStream((InputStream)Files.newInputStream(Paths.get(this.signatureFilePath, new String[0]), new OpenOption[0]));
            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(sigIn);
            this.pgpSignatureList = (PGPSignatureList)pgpFact.nextObject();
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred when loading the signature file: ", (Throwable)e);
        }
    }

    @Override
    public List<String> fetchRSAKeys() {
        InputStream sigIn = null;
        try {
            sigIn = PGPUtil.getDecoderStream((InputStream)Files.newInputStream(Paths.get(this.signatureFilePath, new String[0]), new OpenOption[0]));
            JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(sigIn);
            PGPSignatureList pgpSigList = (PGPSignatureList)pgpFact.nextObject();
            ArrayList<String> keyIDs = new ArrayList<String>();
            for (int i = 0; i < pgpSigList.size(); ++i) {
                PGPSignature pgpSignature = pgpSigList.get(i);
                long keyID = pgpSignature.getKeyID();
                keyIDs.add(String.format("%016X", keyID));
            }
            ArrayList<String> arrayList = keyIDs;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred when fetching the RSA keys from the Signature file", e);
        }
        finally {
            try {
                if (sigIn != null) {
                    sigIn.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("Exception occurred when closing stream: " + e.getMessage());
            }
        }
    }

    @Override
    public JcaPGPPublicKeyRingCollection findPublicKeys(List<String> keyIDs) {
        try {
            ArrayList keyRings = new ArrayList();
            for (String keyId : keyIDs) {
                String downloadURL = PatchGPGSignatureVerifier.getKeyserverUrl() + keyId;
                URL url = new URL(downloadURL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                if (conn.getResponseCode() == 200) {
                    InputStream in = conn.getInputStream();
                    JcaPGPPublicKeyRingCollection pgpPub = new JcaPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in));
                    Iterator keyRingIterator = pgpPub.getKeyRings();
                    while (keyRingIterator.hasNext()) {
                        keyRings.add(keyRingIterator.next());
                    }
                    continue;
                }
                throw new IOException("Failed to fetch public key from server: " + conn.getResponseMessage() + ", key server request URL: " + downloadURL);
            }
            return new JcaPGPPublicKeyRingCollection(keyRings);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred when downloading the public key file: ", e);
        }
    }

    @Override
    public boolean verifySignature(JcaPGPPublicKeyRingCollection publicKeyCollection) {
        InputStream dataIn = null;
        boolean overallStatus = false;
        try {
            for (int i = 0; i < this.pgpSignatureList.size(); ++i) {
                int ch;
                PGPSignature pgpSignature = this.pgpSignatureList.get(i);
                PGPPublicKey key = publicKeyCollection.getPublicKey(pgpSignature.getKeyID());
                if (key == null) {
                    LOGGER.info("Public key not found for the key: " + pgpSignature.getKeyID());
                    continue;
                }
                pgpSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), key);
                dataIn = Files.newInputStream(Paths.get(this.actualFilePath, new String[0]), new OpenOption[0]);
                while ((ch = dataIn.read()) >= 0) {
                    pgpSignature.update((byte)ch);
                }
                dataIn.close();
                if (pgpSignature.verify()) {
                    overallStatus = true;
                    LOGGER.info("Signature verification success for key ID: " + pgpSignature.getKeyID());
                    continue;
                }
                LOGGER.warn("Signature verification failed for key ID: " + pgpSignature.getKeyID());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred when GPG signature verification process :: ", e);
        }
        finally {
            try {
                if (dataIn != null) {
                    dataIn.close();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred when closing stream: " + e.getMessage());
            }
        }
        return overallStatus;
    }

    public static String getKeyserverUrl() {
        return DEFAULT_KEYSERVER_URL;
    }
}

