/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.gpgverifier;

import com.adventnet.downloadutils.DownloadManager;
import com.adventnet.downloadutils.DownloadStatus;
import com.adventnet.sym.server.downloadmgr.LinuxFlavor;
import com.adventnet.sym.server.downloadmgr.OfflineMetaDetails;
import com.adventnet.sym.server.gpgverifier.MetaDetails;
import com.adventnet.sym.server.gpgverifier.PatchGPGSignatureVerifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openpgp.jcajce.JcaPGPPublicKeyRingCollection;

public class LinuxMetaGPGVerificationUtil {
    private static final Logger LOGGER = LogManager.getLogger(LinuxMetaGPGVerificationUtil.class);
    private static final String RELEASE_FILE_NAME = "Release";
    private static final String SIGNATURE_FILE_NAME = "Release.gpg";
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String SHA256 = "SHA256";
    private static final List<Integer> GPG_VERIFICATION_REQUIRED_FLAVORS = Arrays.asList(LinuxFlavor.UBUNTU.getFlavorId());

    public boolean isVerificationRequiredForFlavor(int flavor) {
        return GPG_VERIFICATION_REQUIRED_FLAVORS.contains(flavor);
    }

    public List<MetaDetails> getVerifiedReleaseDetailsOfFlavor(LinuxFlavor syncFlavor, List<OfflineMetaDetails> offlineMetaList) {
        ArrayList<MetaDetails> allRepoReleaseDetails = new ArrayList<MetaDetails>();
        try {
            boolean isVerificationRequired = this.isVerificationRequiredForFlavor(syncFlavor.getFlavorId());
            if (!isVerificationRequired) {
                LOGGER.info("GPG Meta verification not required for the flavor: " + syncFlavor.getFlavorName());
                ArrayList<MetaDetails> arrayList = allRepoReleaseDetails;
                return arrayList;
            }
            LOGGER.info("GPG Meta verification required for the flavor: " + syncFlavor.getFlavorName());
            Set<String> supportedFiles = offlineMetaList.stream().map(meta -> meta.filePath).map(filePath -> filePath.substring(filePath.indexOf("dists/") + 6)).map(filePath -> filePath.substring(filePath.indexOf(47) + 1)).collect(Collectors.toSet());
            List repoNames = offlineMetaList.stream().map(offlineMetaDetail -> offlineMetaDetail.filePath).map(LinuxMetaGPGVerificationUtil::extractRepoName).distinct().collect(Collectors.toList());
            String baseUrl = LinuxMetaGPGVerificationUtil.extractBaseURL(offlineMetaList.get((int)0).filePath);
            for (String repo : repoNames) {
                String destinationFileLocation;
                block18: {
                    String releaseFileLocation = baseUrl + repo + "/";
                    destinationFileLocation = LinuxMetaGPGVerificationUtil.getReleaseFolderLocation(syncFlavor.getFlavorName()) + File.separator + repo + File.separator;
                    DownloadStatus releaseFileDownloadResponse = DownloadManager.getInstance().downloadFile(releaseFileLocation + RELEASE_FILE_NAME, destinationFileLocation + RELEASE_FILE_NAME);
                    DownloadStatus signFileDownloadResponse = DownloadManager.getInstance().downloadFile(releaseFileLocation + SIGNATURE_FILE_NAME, destinationFileLocation + SIGNATURE_FILE_NAME);
                    if (releaseFileDownloadResponse.getStatus() != 0 || signFileDownloadResponse.getStatus() != 0) {
                        LOGGER.warn("Meta Release data download failed for the Repo: " + repo);
                        continue;
                    }
                    try {
                        PatchGPGSignatureVerifier patchGPGSignatureVerifier = new PatchGPGSignatureVerifier(destinationFileLocation + RELEASE_FILE_NAME, destinationFileLocation + SIGNATURE_FILE_NAME);
                        List<String> keys = patchGPGSignatureVerifier.fetchRSAKeys();
                        JcaPGPPublicKeyRingCollection publicKeyCollection = patchGPGSignatureVerifier.findPublicKeys(keys);
                        boolean valid = patchGPGSignatureVerifier.verifySignature(publicKeyCollection);
                        if (!valid) {
                            LOGGER.warn("Meta Release data file signature verification failed for the Repo: " + repo);
                        }
                        break block18;
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception Occurred in LinuxMetaGPGVerificationUtil: Signature verification process failed: ", (Throwable)e);
                    }
                    continue;
                }
                List metaDetails = this.extractChecksumDetailsFromReleaseFile(repo, destinationFileLocation + RELEASE_FILE_NAME, supportedFiles).stream().filter(detail -> detail.getChecksumType().equals(SHA256)).collect(Collectors.toList());
                allRepoReleaseDetails.addAll(metaDetails);
            }
            ArrayList<MetaDetails> arrayList = allRepoReleaseDetails;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Sync of offline meta release files details failed", e);
        }
        finally {
            String releaseDirectoryLocation = LinuxMetaGPGVerificationUtil.getReleaseFolderLocation(syncFlavor.getFlavorName());
            try {
                LinuxMetaGPGVerificationUtil.deleteDirectory(new File(releaseDirectoryLocation));
            }
            catch (Exception e) {
                LOGGER.warn("Exception occurred when deleting the linux meta release folder", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaDetails> extractChecksumDetailsFromReleaseFile(String repo, String releaseFileName, Set<String> supportedFiles) throws IOException {
        String sourceMethod = "extractChecksumDetailsFromReleaseFile";
        ArrayList<MetaDetails> metaDetails = new ArrayList<MetaDetails>();
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(releaseFileName));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!(line = line.trim()).contains("/") || !line.contains(".") || (parts = line.split("\\s+")).length != 3) continue;
                String checksum = parts[0];
                String fileSize = parts[1];
                String metaFilePath = parts[2];
                if (supportedFiles.stream().noneMatch(metaFilePath::equals)) continue;
                MetaDetails metaDetail = new MetaDetails(repo, metaFilePath, Long.valueOf(fileSize), checksum, LinuxMetaGPGVerificationUtil.getChecksumType(checksum));
                metaDetails.add(metaDetail);
            }
        }
        return metaDetails;
    }

    public static String extractRepoName(String filePath) {
        String regex = "dists/([^/]+)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(filePath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Repo name not found in URL");
    }

    private static String extractBaseURL(String filePath) {
        String regex = "^(.*?dists/)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(filePath);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Base URL not found in the provided file path.");
    }

    private static String getChecksumType(String checksum) {
        switch (checksum.length()) {
            case 32: {
                return MD5;
            }
            case 40: {
                return SHA1;
            }
            case 64: {
                return SHA256;
            }
        }
        return SHA256;
    }

    private static String getReleaseFolderLocation(String flavor) {
        return "updatedb" + File.separator + "linux" + File.separator + flavor + File.separator + "offline-meta" + File.separator + "release";
    }

    private static void deleteDirectory(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                LinuxMetaGPGVerificationUtil.deleteDirectory(file);
            }
        }
        directory.delete();
    }
}

