/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import com.adventnet.downloadutils.DownloadManager;
import com.adventnet.downloadutils.DownloadStatus;
import com.adventnet.sym.server.downloadmgr.DCDownloadMgrProxyServer;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OfficePatchActionsHandler {
    private static final Logger LOGGER = LogManager.getLogger(DCDownloadMgrProxyServer.class);
    private static Logger officepatch_logger = LogManager.getLogger((String)"OFFICEPATCH_LOGGER");
    static DownloadManager dwnManager = new DownloadManager();
    static DCDownloadMgrProxyServer dcDownloadMgrProxyServer = new DCDownloadMgrProxyServer();

    public boolean preReqDepCheckAndDownload() {
        DownloadStatus dwnStatus;
        String officeMetaExedownloadUrl = "https://patchdb.manageengine.com/crs/patches/officemeta.exe";
        String officeDsExedownloadUrl = "https://patchdb.manageengine.com/crs/patches/dsOfficeDownloader.exe";
        String officeMetaExePath = "store" + File.separator + "officemeta.exe";
        String officeDsExePath = "store" + File.separator + "dsOfficeDownloader.exe";
        File f = new File(officeMetaExePath);
        boolean officeMetaAvail = true;
        boolean dsOfficeAvail = true;
        if (!f.exists()) {
            dwnStatus = dwnManager.downloadFile(officeMetaExedownloadUrl, officeMetaExePath);
            officeMetaAvail = dwnStatus.getStatus() == 0;
        } else {
            officepatch_logger.debug("officemeta.exe File already exists. Download Skipped.");
        }
        f = new File(officeDsExePath);
        if (!f.exists()) {
            dwnStatus = dwnManager.downloadFile(officeDsExedownloadUrl, officeDsExePath);
            dsOfficeAvail = dwnStatus.getStatus() == 0;
        } else {
            officepatch_logger.debug("officemeta.exe File already exists. Download Skipped.");
        }
        return dsOfficeAvail && officeMetaAvail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ArrayList<Long>> performOfficePatchActions(JSONObject requestObject) throws Exception {
        JSONObject actions = requestObject.getJSONObject("actions");
        JSONArray officeAbbrevArray = requestObject.getJSONArray("OfficeLanguages");
        JSONArray officeProofingLanguages = requestObject.getJSONArray("ProofingToolsLanguages");
        ArrayList<Long> failedPatchesArray = new ArrayList<Long>();
        ArrayList<Long> failureUnknownPatches = new ArrayList<Long>();
        HashMap<String, ArrayList<Long>> map = new HashMap<String, ArrayList<Long>>();
        Iterator keys = actions.keys();
        block15: while (keys.hasNext()) {
            String patchIdAndName = (String)keys.next();
            String[] parts = patchIdAndName.split("-");
            String patchId = parts[0];
            String filename = parts[1];
            JSONArray actionArray = actions.getJSONArray(patchIdAndName);
            long patchID = Long.valueOf(patchId);
            boolean flag = true;
            boolean isOtherIssue = false;
            Properties executionProps = new Properties();
            String logFilePath = "";
            Long fileSize = 0L;
            int errorCode = 0;
            DateTimeFormatter time = DateTimeFormatter.ofPattern("HHmm");
            DateTimeFormatter date = DateTimeFormatter.ofPattern("yyyyMMdd");
            LocalDateTime now = LocalDateTime.now();
            String currTime = time.format(now);
            String currDate = date.format(now);
            block16: for (int i = 0; i < actionArray.length(); ++i) {
                String arg2;
                JSONObject action = actionArray.getJSONObject(i);
                int actiontype = action.getInt("actiontype");
                String arg1 = action.getString("actionarg1");
                String cmdArg = arg2 = action.getString("actionarg2");
                arg1 = OfficePatchActionsHandler.replacePlaceHolder(arg1, patchID, filename);
                arg2 = OfficePatchActionsHandler.replacePlaceHolder(arg2, patchID, filename);
                String arg1Ref = arg1;
                String arg2Ref = arg2;
                File arg1File = new File(arg1);
                File arg2File = new File(arg2);
                if (!flag) {
                    officepatch_logger.log(Level.DEBUG, "Failed to process office patch id " + patchID);
                    failedPatchesArray.add(patchID);
                    continue block15;
                }
                if (isOtherIssue) {
                    officepatch_logger.log(Level.DEBUG, "Failed due to other actions for patchid" + patchID);
                    failureUnknownPatches.add(patchID);
                    continue block15;
                }
                switch (actiontype) {
                    case 7: {
                        boolean success;
                        if (arg1.contains("logs") && arg1File.exists()) {
                            success = new File(arg1).delete();
                            if (success) {
                                officepatch_logger.log(Level.DEBUG, "Log folder already existed \"" + arg1 + "\" deleted successfully");
                            } else {
                                officepatch_logger.log(Level.DEBUG, "Log folder already existed \"" + arg1 + "\" delete failed");
                                isOtherIssue = true;
                            }
                        }
                        if (!arg1File.exists()) {
                            success = arg1File.mkdirs();
                            if (success) continue block16;
                            officepatch_logger.log(Level.DEBUG, "Folder not created for path " + arg1File);
                            isOtherIssue = true;
                            continue block16;
                        }
                        officepatch_logger.log(Level.DEBUG, "Folder is not created as it already exists: " + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                        continue block16;
                    }
                    case 6: {
                        if (arg1File.exists()) {
                            boolean success = dcDownloadMgrProxyServer.deleteFilesInDirectory(arg1, false);
                            if (success) continue block16;
                            isOtherIssue = true;
                            officepatch_logger.debug("Deletion of directory failed for path: " + arg1);
                            continue block16;
                        }
                        officepatch_logger.debug("Deletion skipped as directory not found: " + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                        continue block16;
                    }
                    case 8: {
                        if (arg1File.exists()) {
                            boolean success = new File(String.valueOf(arg1File)).delete();
                            if (success) continue block16;
                            isOtherIssue = true;
                            officepatch_logger.debug("Deletion of file failed for path : " + arg1);
                            continue block16;
                        }
                        officepatch_logger.debug("Deletion skipped as file not found:: " + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                        continue block16;
                    }
                    case 3: {
                        officepatch_logger.debug("Run Command execution in progress");
                        if (!arg1File.exists()) {
                            officepatch_logger.log(Level.DEBUG, "Execution failed as exe unavailable: " + arg1);
                            flag = false;
                            continue block16;
                        }
                        String s1 = arg1;
                        if (arg1.contains(" ")) {
                            s1 = "\"" + arg1 + "\"";
                        }
                        ArrayList<String> cmdArgArr = new ArrayList<String>();
                        cmdArgArr.add(s1);
                        cmdArgArr.addAll(Arrays.asList(cmdArg.split(" ")));
                        for (int iterator2 = 0; iterator2 < cmdArgArr.size(); ++iterator2) {
                            cmdArgArr.set(iterator2, OfficePatchActionsHandler.replacePlaceHolder((String)cmdArgArr.get(iterator2), patchID, filename));
                        }
                        officepatch_logger.log(Level.DEBUG, "command for run action is " + cmdArgArr);
                        executionProps = OfficePatchActionsHandler.executeCmd(cmdArgArr);
                        flag = (Boolean)executionProps.get("exitValue");
                        if (!flag) {
                            officepatch_logger.log(Level.DEBUG, "Command execution failed");
                            this.copyAndParseOfficeLog(logFilePath, patchID, currDate, currTime);
                            continue block16;
                        }
                        officepatch_logger.log(Level.DEBUG, "Command execution successful");
                        if (logFilePath.isEmpty() || !new File(logFilePath).exists()) continue block16;
                        boolean success = new File(logFilePath).delete();
                        if (success) {
                            officepatch_logger.log(Level.DEBUG, logFilePath + " Deletion Success");
                            continue block16;
                        }
                        officepatch_logger.log(Level.DEBUG, logFilePath + " Deletion Failed");
                        continue block16;
                    }
                    case 2: {
                        officepatch_logger.log(Level.DEBUG, "Entered Download action for office patchid " + patchID);
                        String destionationfile = arg2 + File.separator + arg1.substring(arg1.lastIndexOf("/") + 1);
                        officepatch_logger.log(Level.DEBUG, "download destination file path is " + destionationfile);
                        DownloadStatus downloadStatus = dwnManager.downloadFile(arg1, destionationfile);
                        errorCode = downloadStatus.getStatus();
                        if (errorCode == 0) {
                            officepatch_logger.log(Level.DEBUG, "File Download Success: " + arg2.substring(arg2.lastIndexOf("/") + 1, arg2.length()));
                            continue block16;
                        }
                        officepatch_logger.log(Level.DEBUG, "Download Failed: " + arg2.substring(arg2.lastIndexOf("/") + 1));
                        isOtherIssue = true;
                        continue block16;
                    }
                    case 5: {
                        officepatch_logger.log(Level.DEBUG, "UPDATING XML" + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                        if (!arg1File.exists()) {
                            officepatch_logger.log(Level.DEBUG, "Updation failed as XML missing: " + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                            isOtherIssue = true;
                            continue block16;
                        }
                        if (arg2.contains("Logging/Path=")) {
                            logFilePath = arg2.split("Logging/Path=")[1];
                        }
                        OfficePatchActionsHandler.updateXML(arg1, arg2);
                        officepatch_logger.log(Level.DEBUG, arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()) + " Updated");
                        continue block16;
                    }
                    case 11: {
                        if (!arg1File.exists()) {
                            officepatch_logger.log(Level.DEBUG, "Language updating failed as XML missing: " + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                            isOtherIssue = false;
                            continue block16;
                        }
                        if (arg2.contains("Logging/Path=")) {
                            logFilePath = arg2.split("Logging/Path=")[1];
                        }
                        this.updateLangInXML(arg1, arg2, officeAbbrevArray, officeProofingLanguages);
                        officepatch_logger.log(Level.DEBUG, arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()) + " Language/ProofingTool updated");
                        continue block16;
                    }
                    case 4: {
                        officepatch_logger.log(Level.DEBUG, "ZIP Action in progress");
                        ZipOutputStream out = null;
                        FileOutputStream fos = null;
                        if (arg1File.exists()) {
                            try {
                                File dirObj = new File(arg1);
                                File parentDirObj = new File(arg1);
                                fos = new FileOutputStream(arg2);
                                out = new ZipOutputStream(fos);
                                this.zipWithSubDirectories(dirObj, out, parentDirObj);
                                fileSize = arg2File.length();
                                officepatch_logger.log(Level.DEBUG, "Folder Zipped successfully: " + arg2.substring(arg2.lastIndexOf("\\") + 1, arg2.length()));
                                officepatch_logger.log(Level.DEBUG, "Folder " + arg2.substring(arg2.lastIndexOf("\\") + 1, arg2.length()) + " with file size " + fileSize + " ZIPPED_SUCCESSFULLY");
                                continue block16;
                            }
                            catch (Exception ee) {
                                isOtherIssue = true;
                                officepatch_logger.error(ee.getMessage());
                                continue block16;
                            }
                            finally {
                                out.close();
                                fos.close();
                            }
                        }
                        officepatch_logger.log(Level.DEBUG, "ZIP Action failed as folder is missing: " + arg1.substring(arg1.lastIndexOf("\\") + 1, arg1.length()));
                        isOtherIssue = true;
                        continue block16;
                    }
                }
            }
        }
        map.put("failedInRunCommand", failedPatchesArray);
        map.put("failedInOtherActions", failureUnknownPatches);
        return map;
    }

    public void updateLangInXML(String xmlPath, String change, JSONArray officeAbbrevArray, JSONArray officeProofingLanguages) {
        String proofingTools = "ProofingTools";
        try {
            int i;
            String value = change.substring(change.lastIndexOf("=") + 1, change.length());
            change = change.substring(0, change.lastIndexOf("="));
            String tag = change.substring(0, change.lastIndexOf("/"));
            String attribute = change.substring(change.lastIndexOf("/") + 1, change.length());
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = docFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(xmlPath);
            Node tagNode = doc.getElementsByTagName(tag).item(0);
            NamedNodeMap attr = tagNode.getAttributes();
            Node nodeAttr = attr.getNamedItem(attribute);
            Node product = doc.getElementsByTagName("Product").item(0);
            String[] officeAbbrev = new String[officeAbbrevArray.length()];
            for (i = 0; i < officeAbbrevArray.length(); ++i) {
                officeAbbrev[i] = officeAbbrevArray.getString(i);
            }
            if (value.equals(proofingTools) && (officeAbbrev == null || officeAbbrev.length < 0)) {
                return;
            }
            if (!doc.getElementsByTagName("Product").item(1).hasChildNodes() && value.equals(proofingTools)) {
                Node add = doc.getElementsByTagName("Add").item(0);
                Element proofingToolElement = doc.createElement("Product");
                add.appendChild(proofingToolElement);
                proofingToolElement.setAttribute(attribute, proofingTools);
            }
            if (value.equals(proofingTools)) {
                product = doc.getElementsByTagName("Product").item(1);
                officeAbbrev = new String[officeProofingLanguages.length()];
                for (i = 0; i < officeProofingLanguages.length(); ++i) {
                    officeAbbrev[i] = officeProofingLanguages.getString(i);
                }
            }
            if (product.hasChildNodes()) {
                NodeList productList = product.getChildNodes();
                while (productList.getLength() > 0) {
                    Node node = productList.item(0);
                    product.removeChild(node);
                }
            }
            for (int iter = 0; iter < officeAbbrev.length; ++iter) {
                Element langElement = doc.createElement("Language");
                product.appendChild(langElement);
                langElement.setAttribute(attribute, officeAbbrev[iter]);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(xmlPath));
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            officepatch_logger.log(Level.DEBUG, "Error while updating languages/proofing tools in download xml with this exception: " + ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipWithSubDirectories(File dirObj, ZipOutputStream out, File parentDir) throws IOException {
        byte[] data = new byte[2048];
        File[] files = dirObj.listFiles();
        try {
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.zipWithSubDirectories(file, out, parentDir);
                        continue;
                    }
                    FileInputStream fi = null;
                    BufferedInputStream origin = null;
                    try {
                        int count;
                        fi = new FileInputStream(file);
                        String name = file.getAbsolutePath().replace(parentDir.getAbsolutePath() + "\\", "");
                        ZipEntry entry = new ZipEntry(name);
                        out.putNextEntry(entry);
                        origin = new BufferedInputStream(fi, 2048);
                        while ((count = origin.read(data, 0, 2048)) != -1) {
                            out.write(data, 0, count);
                        }
                    }
                    catch (Exception e) {
                        officepatch_logger.error("Exception occured during zip action " + e.getMessage());
                    }
                    finally {
                        if (origin != null) {
                            origin.close();
                        }
                        if (fi != null) {
                            fi.close();
                        }
                    }
                }
            }
        }
        catch (Exception ee) {
            officepatch_logger.error("Exception occured during zip action" + ee.getMessage());
        }
        finally {
            out.flush();
            out.closeEntry();
        }
    }

    public static void updateXML(String xmlPath, String change) {
        try {
            String value = change.substring(change.lastIndexOf("=") + 1, change.length());
            change = change.substring(0, change.lastIndexOf("="));
            String tag = change.substring(0, change.lastIndexOf("/"));
            String attribute = change.substring(change.lastIndexOf("/") + 1, change.length());
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(xmlPath);
            Node tagNode = doc.getElementsByTagName(tag).item(0);
            NamedNodeMap attr = tagNode.getAttributes();
            Node nodeAttr = attr.getNamedItem(attribute);
            nodeAttr.setTextContent(value);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(xmlPath));
            transformer.transform(source, result);
        }
        catch (Exception ee) {
            officepatch_logger.error("Exception occurred during updating xml  " + ee.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public static Properties executeCmd(List<String> cmdArgArr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String replacePlaceHolder(String arg, Long patchId, String filename) {
        if (arg == null) {
            return "";
        }
        String storeDir = "store";
        String logDir = "logs" + File.separator;
        String duplicateArg = arg;
        block4: for (int i = 0; i < duplicateArg.length(); ++i) {
            if (duplicateArg.charAt(i) != '$') continue;
            for (int j = i; j < duplicateArg.length(); ++j) {
                File f;
                String path;
                if (duplicateArg.charAt(j) != '}') continue;
                String replace = duplicateArg.substring(i, j + 1);
                if (replace.equals("${storedir}")) {
                    path = "";
                    try {
                        f = new File(".");
                        path = f.getCanonicalPath();
                        path = path + File.separator + storeDir;
                    }
                    catch (Exception e) {
                        officepatch_logger.log(Level.WARN, "Exception while finding working directory", (Throwable)e);
                    }
                    storeDir = path;
                    arg = arg.replace(replace, storeDir);
                } else if (replace.equals("${logdir}")) {
                    path = "";
                    try {
                        f = new File(".");
                        path = f.getCanonicalPath();
                        path = path + File.separator + logDir;
                    }
                    catch (Exception e) {
                        officepatch_logger.log(Level.WARN, "Exception while finding working directory", (Throwable)e);
                    }
                    logDir = path;
                    arg = arg.replace(replace, logDir);
                } else if (replace.equals("${patchid}")) {
                    arg = arg.replace(replace, patchId.toString());
                } else if (replace.equals("${fileName}")) {
                    String fileName = patchId.toString() + "-" + filename;
                    arg = arg.replace(replace, fileName);
                } else {
                    officepatch_logger.log(Level.DEBUG, "place holder not found ");
                }
                i = j;
                continue block4;
            }
        }
        return arg;
    }

    public String copyAndParseOfficeLog(String logFilePath, Long patchId, String currDate, String currTime) throws Exception {
        officepatch_logger.log(Level.DEBUG, "Copy and parse log for office has started with logfilepath " + logFilePath);
        StringBuilder errorCodeAndSourcePath = new StringBuilder();
        String userName = System.getenv("username");
        String driveLetter = System.getenv("SystemDrive");
        driveLetter = driveLetter.toLowerCase();
        String sourceDrive = driveLetter + File.separator + "Users" + File.separator + userName + File.separator + "AppData" + File.separator + "Local" + File.separator + "Temp" + File.separator;
        String logFileName = userName + "-" + currDate + "-" + currTime + ".log";
        String sourcePath = sourceDrive + logFileName;
        String destPath = logFilePath + File.separator + String.valueOf(patchId) + "_office_log";
        File source = new File(sourcePath);
        File dest = new File(destPath);
        boolean copySuccess = false;
        try {
            officepatch_logger.log(Level.DEBUG, "Started copying the log file from - ", (Object)sourcePath);
            if (source.exists() && new File(logFilePath).exists()) {
                Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
                if (dest.exists()) {
                    copySuccess = true;
                    officepatch_logger.log(Level.DEBUG, logFilePath + "--Log folder copied successfully");
                } else {
                    officepatch_logger.log(Level.DEBUG, logFilePath + "--Log folder copy Failed");
                }
            } else {
                officepatch_logger.log(Level.DEBUG, "Source or destination not exist , proceeding to parse the log file");
            }
        }
        catch (Exception e) {
            officepatch_logger.log(Level.WARN, "Exception occurred during copying ", (Throwable)e);
            officepatch_logger.log(Level.WARN, "Proceeding to parse the log file.");
        }
        File file = new File(sourcePath);
        if (copySuccess) {
            file = new File(destPath);
            sourcePath = destPath;
        }
        if (new File(sourcePath).exists()) {
            officepatch_logger.log(Level.INFO, "Parsing started for log file " + sourcePath);
            BufferedReader br = null;
            String line = null;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-16"));
            line = br.readLine();
            String[] splittedLineArray = null;
            while (line != null) {
                splittedLineArray = line.split("\\s");
                if (line.contains("Attempt") && line.contains("ErrorCode") && line.contains("SourcePath")) {
                    for (int i = 0; i < splittedLineArray.length; ++i) {
                        if (splittedLineArray[i].contains("ErrorCode")) {
                            String errorCode = "ErrorCode:";
                            String value = splittedLineArray[i + 1];
                            errorCodeAndSourcePath.append(errorCode).append(value, 0, value.length() - 1).append(".").append("@@@");
                            continue;
                        }
                        if (!splittedLineArray[i].contains("SourcePath")) continue;
                        String SourcePath = splittedLineArray[i];
                        SourcePath = SourcePath.substring(15, SourcePath.length() - 18);
                        int slashCount = 0;
                        String url = "";
                        String domain = "";
                        boolean flag = false;
                        for (int count = 0; count < SourcePath.length(); ++count) {
                            if (SourcePath.charAt(SourcePath.length() - 1 - count) == '.' && !flag) {
                                domain = SourcePath.substring(SourcePath.length() - 1 - count, SourcePath.length());
                                flag = true;
                            }
                            if (SourcePath.charAt(count) != '/' || ++slashCount != 3) continue;
                            url = url + SourcePath.substring(0, count);
                            break;
                        }
                        errorCodeAndSourcePath.append(url).append("@@@").append(domain);
                    }
                    break;
                }
                line = br.readLine();
            }
            officepatch_logger.log(Level.DEBUG, "Parsing Ended for log file " + sourcePath);
        }
        if (errorCodeAndSourcePath.toString().isEmpty()) {
            return sourcePath;
        }
        return errorCodeAndSourcePath.toString();
    }
}

