/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import com.adventnet.downloadutils.DownloadManager;
import com.adventnet.downloadutils.DownloadStatus;
import com.adventnet.downloadutils.SSLValidationType;
import com.adventnet.sym.server.downloadmgr.LinuxFlavor;
import com.adventnet.sym.server.downloadmgr.OfflineMetaDetails;
import com.adventnet.sym.server.downloadmgr.PC1InputStream;
import com.adventnet.sym.server.gpgverifier.LinuxMetaGPGVerificationUtil;
import com.adventnet.sym.server.gpgverifier.MetaDetails;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinuxOffline {
    private static final Logger LOGGER = LogManager.getLogger(LinuxOffline.class);

    private static void downloadRepomdMeta(String repomdXml, String url) {
        try {
            File file = new File(repomdXml);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document doc = docBuilder.parse(file);
            NodeList nodeList = doc.getElementsByTagName("data");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                DownloadStatus dloadStatus;
                Element element = (Element)nodeList.item(i);
                NodeList locations = element.getElementsByTagName("location");
                String filename = locations.item(0).getAttributes().getNamedItem("href").getNodeValue();
                filename = filename.substring(filename.lastIndexOf("/") + 1);
                String downloadUrl = url.substring(0, url.lastIndexOf("/") + 1) + filename;
                String destFile = repomdXml.substring(0, repomdXml.lastIndexOf(File.separator) + 1) + filename;
                NodeList checksumNode = element.getElementsByTagName("checksum");
                String checksumType = checksumNode.item(0).getAttributes().getNamedItem("type").getNodeValue();
                String checksum = checksumNode.item(0).getTextContent();
                if (checksumType.equalsIgnoreCase("sha")) {
                    checksumType = "sha1";
                }
                if ((dloadStatus = DownloadManager.getInstance().downloadFileWithCheckSumValidation(downloadUrl, destFile, checksum, checksumType, null, null, new SSLValidationType[0])).getStatus() == 0) {
                    LOGGER.debug(downloadUrl + " download success");
                    continue;
                }
                LOGGER.debug(downloadUrl + " download failed");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private static HashMap<String, String> downloadMirrorList(String mirrorList) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(mirrorList));
            HashMap<String, String> loc = new HashMap<String, String>();
            String latestLink = null;
            while ((line = br.readLine()) != null) {
                latestLink = line;
            }
            String repoLink = latestLink.trim();
            String repomdLink = repoLink + (repoLink.endsWith("/") ? "" : "/") + "repodata/repomd.xml";
            mirrorList = mirrorList.replace("mirror.list", "repodata/repomd.xml");
            DownloadStatus dwnStatus = DownloadManager.getInstance().downloadFile(repomdLink, mirrorList);
            LOGGER.debug("repomd.xml file extracted from MirrorList file");
            loc.put("destinationFile", mirrorList);
            loc.put("downloadUrl", repomdLink);
            return loc;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return null;
        }
    }

    private static void updateOfflineMetaDataDetails(String fileName) {
        try {
            List<OfflineMetaDetails> offlineMetaList = LinuxOffline.getOfflineMetaListFromSQLFile(fileName);
            int totalCount = 0;
            int totalSuccess = 0;
            int totalFailure = 0;
            for (LinuxFlavor flavor : LinuxFlavor.values()) {
                List<OfflineMetaDetails> offlineMetaListFilteredByFlavor = offlineMetaList.stream().filter(m -> m.flavorID == flavor.getFlavorId()).collect(Collectors.toList());
                LinuxMetaGPGVerificationUtil verificationUtil = new LinuxMetaGPGVerificationUtil();
                boolean verificationRequired = verificationUtil.isVerificationRequiredForFlavor(flavor.getFlavorId());
                List<MetaDetails> verifiedReleaseDetailsOfFlavor = verificationUtil.getVerifiedReleaseDetailsOfFlavor(flavor, offlineMetaListFilteredByFlavor);
                AtomicInteger count = new AtomicInteger(0);
                AtomicInteger success = new AtomicInteger(0);
                AtomicInteger failure = new AtomicInteger(0);
                offlineMetaListFilteredByFlavor.forEach(meta -> {
                    DownloadStatus dwnStatus;
                    count.addAndGet(1);
                    if (verificationRequired) {
                        String repoName = LinuxMetaGPGVerificationUtil.extractRepoName(meta.filePath);
                        Optional<MetaDetails> metaChecksumDetail = verifiedReleaseDetailsOfFlavor.stream().filter(detail -> detail.getRepoName().equals(repoName)).filter(detail -> meta.filePath.contains(detail.getFilePath())).findFirst();
                        if (metaChecksumDetail.isPresent()) {
                            MetaDetails metaDetail = metaChecksumDetail.get();
                            meta.checksum = metaDetail.getChecksum();
                            meta.checksumType = metaDetail.getChecksumType();
                        }
                        dwnStatus = DownloadManager.dwnmgr.downloadFileWithCheckSumValidation(meta.filePath, meta.destinationFilePath, meta.checksum, meta.checksumType, null, null, new SSLValidationType[0]);
                    } else {
                        dwnStatus = DownloadManager.dwnmgr.downloadFile(meta.filePath, meta.destinationFilePath);
                    }
                    if (dwnStatus.getStatus() == 0) {
                        success.addAndGet(1);
                        if (Arrays.asList(16, 512, 1024, 2048, 4096).contains(meta.flavorID)) {
                            if (meta.flavorID == 2048) {
                                HashMap<String, String> loc = LinuxOffline.downloadMirrorList(meta.destinationFilePath);
                                meta.destinationFilePath = loc.get("destinationFile");
                                meta.filePath = loc.get("downloadUrl");
                            }
                            LinuxOffline.downloadRepomdMeta(meta.destinationFilePath, meta.filePath);
                        }
                    } else {
                        failure.addAndGet(1);
                    }
                });
                totalCount += count.get();
                totalSuccess += success.get();
                totalFailure += failure.get();
            }
            LOGGER.debug((Object)totalCount);
            LOGGER.debug("Success: " + totalSuccess);
            LOGGER.debug("Failure: " + totalFailure);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private static List<OfflineMetaDetails> getOfflineMetaListFromSQLFile(String fileName) {
        ArrayList<OfflineMetaDetails> offlineMetaDetails = new ArrayList<OfflineMetaDetails>();
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("INSERT into OfflineMetaDataDetails values")) {
                    String[] arr = line.split(",");
                    for (int i = 0; i < arr.length; ++i) {
                        String str = arr[i];
                        if (!str.startsWith("'http") || !arr[i + 1].equalsIgnoreCase("'4'") && !arr[i + 1].equalsIgnoreCase("'8'") && !arr[i + 1].equalsIgnoreCase("'16'") && !arr[i + 1].equalsIgnoreCase("'512'") && !arr[i + 1].equalsIgnoreCase("'1024'") && !arr[i + 1].equalsIgnoreCase("'256'") && !arr[i + 1].equalsIgnoreCase("'2048'") && !arr[i + 1].equalsIgnoreCase("'4096'")) continue;
                        String flavorIDStr = arr[i + 1];
                        flavorIDStr = flavorIDStr.substring(1, flavorIDStr.length() - 1);
                        int flavorID = Integer.parseInt(flavorIDStr);
                        String flavorName = LinuxFlavor.getLinuxCategory(flavorID);
                        String productIDStr = arr[i + 2];
                        productIDStr = productIDStr.substring(1, productIDStr.length() - 1);
                        int productID = Integer.parseInt(productIDStr);
                        String checksum = arr[i + 3];
                        checksum = checksum.substring(1, checksum.length() - 1);
                        String checksumType = arr[i + 4];
                        checksumType = checksumType.substring(1, checksumType.length() - 1);
                        String URLname = arr[i - 1];
                        URLname = URLname.substring(1, URLname.length() - 1);
                        String downloadUrl = str = str.substring(1, str.length() - 1);
                        offlineMetaDetails.add(new OfflineMetaDetails(URLname, flavorID, productID, downloadUrl, null, null));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return offlineMetaDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initiateDecryption(File encryptedFile, String fileName) throws Exception {
        fileName = fileName.substring(0, fileName.length() - 4);
        String decryptedFile = fileName + "_decrypted";
        try (FileInputStream fis = null;){
            fis = new FileInputStream(encryptedFile);
            String outFile = fileName + "_decrypted.sql";
            LinuxOffline.decryptFile(fis, decryptedFile, outFile, null);
            LOGGER.debug("Let's parse " + outFile);
            LinuxOffline.updateOfflineMetaDataDetails(outFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decryptFile(InputStream encryptedStream, String decryptedFile, String outFile, String taskType) throws Exception {
        PC1InputStream dec_in = null;
        BufferedOutputStream dec_out = null;
        InputStream bis = null;
        FilterOutputStream bos = null;
        try {
            int by;
            String key = "patchmatic";
            dec_in = new PC1InputStream(new BufferedInputStream(encryptedStream), key.getBytes());
            dec_out = new BufferedOutputStream(new FileOutputStream(decryptedFile));
            int c = dec_in.read();
            while (c != -1) {
                ((OutputStream)dec_out).write(c);
                c = dec_in.read();
            }
            dec_in.close();
            ((OutputStream)dec_out).close();
            bis = new BufferedInputStream(new GZIPInputStream(new FileInputStream(decryptedFile)));
            bos = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((by = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(by);
            }
        }
        catch (Exception ee) {
            LOGGER.error(ee.getMessage());
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    public static void parse(String sqlFile) {
        try {
            LOGGER.debug("Required SQL file is " + sqlFile);
            File f = new File(sqlFile);
            LinuxOffline.initiateDecryption(f, sqlFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

