/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import java.util.Arrays;

public enum LinuxFlavor {
    UBUNTU(4, "ubuntu"),
    DEBIAN(8, "debian"),
    CENTOS(16, "centos"),
    REDHAT(32, "redhat"),
    SUSE(128, "suse"),
    PARDUS(256, "pardus"),
    ORACLE(512, "oracle"),
    ROCKY(1024, "rocky"),
    AMAZON(2048, "amazon"),
    ALMA(4096, "alma");

    private final int flavorId;
    private final String flavorName;

    private LinuxFlavor(int flavorId, String flavorName) {
        this.flavorId = flavorId;
        this.flavorName = flavorName;
    }

    public int getFlavorId() {
        return this.flavorId;
    }

    public String getFlavorName() {
        return this.flavorName;
    }

    public String toString() {
        return "LinuxFlavor{flavorId=" + this.flavorId + ", flavorName='" + this.flavorName + '\'' + '}';
    }

    public static String getLinuxCategory(int flavorId) {
        LinuxFlavor flavor = Arrays.stream(LinuxFlavor.values()).filter(linuxFlavor -> linuxFlavor.flavorId == flavorId).findFirst().orElseThrow(() -> new IllegalStateException("No category present for the given linux flavor ID."));
        return flavor.flavorName;
    }
}

