/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import com.adventnet.downloadutils.DownloadManager;
import com.adventnet.downloadutils.DownloadStatus;
import com.adventnet.downloadutils.SSLValidationType;
import com.adventnet.sym.server.downloadmgr.CRTThumbPrintVerifier;
import com.adventnet.sym.server.downloadmgr.LinuxFlavor;
import com.adventnet.sym.server.downloadmgr.LinuxOffline;
import com.adventnet.sym.server.downloadmgr.OfficePatchActionsHandler;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DCDownloadMgrProxyServer {
    private static final Logger LOGGER = LogManager.getLogger(DCDownloadMgrProxyServer.class);
    private static Logger upgrade_logger = LogManager.getLogger((String)"UPGRADE_LOGGER");
    private static Logger updatedb_logger = LogManager.getLogger((String)"UPDATEDB_LOGGER");
    private static Logger updatedb_failed_logger = LogManager.getLogger((String)"UPDATEDB_FAILED_LOGGER");
    private static Logger dwnpatch_logger = LogManager.getLogger((String)"DWNPATCH_LOGGER");
    private static Logger dwnpatch_failed_logger = LogManager.getLogger((String)"DWNPATCH_FAILED_LOGGER");
    private static Logger officepatch_logger = LogManager.getLogger((String)"OFFICEPATCH_LOGGER");
    static DownloadManager dwnManager = null;
    static OfficePatchActionsHandler officePatchActionsHandler = null;
    static int success = 0;
    static int fail = 0;
    static final String CRSURL = "https://patchdb.manageengine.com/";
    static String downloadUrl = null;
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block63: {
            try {
                Properties proxyProperties;
                JSONObject syncModuleDetailsJSON;
                DCDownloadMgrProxyServer proxyserver;
                block62: {
                    proxyserver = new DCDownloadMgrProxyServer();
                    if (args.length == 0 || args.length % 2 == 1) {
                        proxyserver.displayHelp();
                        return;
                    }
                    if (args.length == 2) {
                        if (!args[0].equals("-c")) {
                            proxyserver.displayHelp();
                            return;
                        }
                    } else if (args.length == 4) {
                        if (!(args[2].equals("-f") || args[2].equals("-i") || args[2].equals("-b"))) {
                            proxyserver.displayHelp();
                            return;
                        }
                    } else if (args.length == 6 && !args[4].equals("-b")) {
                        proxyserver.displayHelp();
                        return;
                    }
                    dwnManager = DownloadManager.getInstance();
                    officePatchActionsHandler = new OfficePatchActionsHandler();
                    dwnManager.addDefaultSSLValidationDomainList(new String[]{"patchdb.manageengine.com"});
                    dwnManager.addEnforceHttpsDomainList(new String[]{"patchdb.manageengine.com"});
                    syncModuleDetailsJSON = DCDownloadMgrProxyServer.getSyncModulesJSON("syncModuleDetails.json");
                    if (syncModuleDetailsJSON == null) {
                        updatedb_logger.error("syncModuleDetailsJSON file NOTFOUND or Load Failed, Kindly contact Support");
                        return;
                    }
                    proxyProperties = proxyserver.loadProxySettings();
                    if (args[1].equalsIgnoreCase("updatedb") || args[1].equalsIgnoreCase("dwnpatch") || args[1].equalsIgnoreCase("toolUpgrade")) {
                        try {
                            if (proxyProperties == null) break block62;
                            Properties fileProps = DCDownloadMgrProxyServer.loadUpgradeFile();
                            Boolean autoUpgrade = true;
                            if (fileProps.get("autoUpgrade") != null) {
                                autoUpgrade = Boolean.valueOf(fileProps.get("autoUpgrade").toString());
                            }
                            if (autoUpgrade.booleanValue()) {
                                if (DCDownloadMgrProxyServer.verifyDownloadUrl(syncModuleDetailsJSON) != 1) break block62;
                                StringBuilder sb = DCDownloadMgrProxyServer.readFileFromUnsignedContentJson();
                                JSONTokener tokener = new JSONTokener(sb.toString());
                                JSONObject object = new JSONObject(tokener);
                                JSONObject metaconfig = object.getJSONObject("META_CONFIG");
                                String checkSumType = (String)metaconfig.get("checksum_type");
                                JSONObject meta = object.getJSONObject("META_PROPERTIES");
                                JSONObject metavalues = meta.getJSONObject("closed-network-tool");
                                Long version = Long.valueOf(metavalues.get("version").toString());
                                Long oldVersion = 0L;
                                if (fileProps.get("version") != null) {
                                    oldVersion = Long.valueOf(fileProps.get("version").toString());
                                }
                                if (oldVersion < version) {
                                    String downloadURL = (String)metavalues.get("file_path");
                                    String checkSum = (String)metavalues.get("checksum");
                                    String destinationFile = "upgrade" + File.separator + "UpdateManager.zip";
                                    String upgradeURL = CRSURL + downloadURL;
                                    DownloadStatus dwnStatus = dwnManager.downloadFileWithCheckSumValidation(upgradeURL, destinationFile, checkSum, checkSumType, null, null, new SSLValidationType[0]);
                                    if (dwnStatus.getStatus() == 0) {
                                        try (FileOutputStream fileOutputStream = null;){
                                            fileProps.put("version", oldVersion.toString());
                                            fileProps.put("autoUpgrade", autoUpgrade.toString());
                                            fileProps.put("versionNeedstoUpdated", version.toString());
                                            fileOutputStream = new FileOutputStream("autoUpgrade.prop");
                                            fileProps.store(fileOutputStream, "props file for autougrade process");
                                            DCDownloadMgrProxyServer.unzip(destinationFile, "upgrade");
                                            System.exit(6);
                                            break block62;
                                        }
                                    }
                                    upgrade_logger.log(Level.INFO, "upgrade failed due to download failed with error code:" + dwnStatus.getStatus());
                                    break block62;
                                }
                                LOGGER.info("No need to do upgrade due to version already updated");
                                break block62;
                            }
                            LOGGER.info("autoUpgrade disabled");
                        }
                        catch (Exception e) {
                            upgrade_logger.log(Level.INFO, "Error occurred while upgrading tool : " + e.getMessage());
                        }
                    }
                }
                if (args[1].equalsIgnoreCase("updatedb")) {
                    String parsedBuildNumber;
                    String buildNumber = "";
                    if (args.length == 4 || args.length == 6) {
                        buildNumber = args[args.length - 1];
                    }
                    if ((parsedBuildNumber = DCDownloadMgrProxyServer.parseBuildNumber(buildNumber)) == null) {
                        updatedb_logger.log(Level.INFO, "Verify the entered build number and ensure it follows the approved format: 10.1.2228.01 or 101222801.");
                        return;
                    }
                    if (Long.parseLong(parsedBuildNumber) < 101222801L) {
                        updatedb_logger.log(Level.WARN, "Upgrade to 10.1.2228.01 or later for downloading only the necessary Vulnerability DB sync files.");
                    }
                    updatedb_logger.log(Level.DEBUG, "Build number : " + parsedBuildNumber);
                    if (proxyProperties == null) break block63;
                    String destinationFile = "updatedb";
                    try {
                        new DCDownloadMgrProxyServer().deleteFilesInDirectory(destinationFile, true);
                    }
                    catch (Exception e) {
                        updatedb_logger.error(e.getMessage());
                    }
                    if (DCDownloadMgrProxyServer.verifyDownloadUrl(syncModuleDetailsJSON) == 1) {
                        int crsDownloadStatus = DCDownloadMgrProxyServer.downloadMetaDataFiles("crs-meta-data", "crs-meta-data.xml");
                        if (crsDownloadStatus == 1) {
                            updatedb_logger.log(Level.DEBUG, "Downloaded crs-meta-data.xml file successfully");
                            DCDownloadMgrProxyServer.processUpdateDBRequest(args, parsedBuildNumber, syncModuleDetailsJSON);
                        } else {
                            updatedb_failed_logger.log(Level.INFO, "Download failed for crs-meta-data.xml file");
                        }
                    } else {
                        updatedb_logger.error("Verification failed for :: " + downloadUrl + ". UpdateDB process is terminated.");
                    }
                    break block63;
                }
                if (args[1].equalsIgnoreCase("dwnpatch")) {
                    String fileName = args[3];
                    JSONObject requestObject = proxyserver.loadDownloadJson(fileName);
                    if (requestObject != null) {
                        JSONArray jsonArray1;
                        JSONArray jsonArray = requestObject.has("data") ? requestObject.getJSONArray("data") : new JSONArray();
                        JSONArray jSONArray = jsonArray1 = requestObject.has("pkgs") ? requestObject.getJSONArray("pkgs") : new JSONArray();
                        if (jsonArray.length() > 0 || jsonArray1.length() > 0) {
                            JSONObject officePatchActions;
                            int officePatchLength;
                            JSONObject request;
                            int i;
                            int pkgCount = jsonArray1.length();
                            int patchCount = jsonArray.length();
                            if (patchCount > 0) {
                                dwnpatch_logger.info("Total patch count: " + patchCount);
                            }
                            ArrayList<Long> uploadPatchesList = null;
                            if (DCDownloadMgrProxyServer.verifyDownloadUrl(syncModuleDetailsJSON) == 1 && DCDownloadMgrProxyServer.downloadMetaDataFiles("upload-patches", "uploadPatches.json") == 1) {
                                dwnpatch_logger.log(Level.DEBUG, "Verified checksum for upload-patches.json");
                                String uploadPatchesPath = "updatedb" + File.separator + "dc-crs" + File.separator + "uploadPatches.json";
                                JSONObject uploadPatchesJSON = proxyserver.loadDownloadJson(uploadPatchesPath);
                                uploadPatchesList = proxyserver.getUploadPatchesList(uploadPatchesJSON);
                            }
                            boolean isWindows = System.getProperty("os.name").contains("Windows");
                            File f = new File("downloadRemarks.txt");
                            if (f.exists() && f.isFile()) {
                                f.delete();
                            }
                            for (i = 0; i < patchCount; ++i) {
                                long patchId;
                                String patchName;
                                request = jsonArray.getJSONObject(i);
                                String string = patchName = request.has("PATCHNAME") ? request.getString("PATCHNAME") : request.getString("FILE_NAME");
                                if (patchName.toLowerCase().contains("office") && !isWindows) {
                                    dwnpatch_logger.info("Linux OS flavors do not support Office patches.");
                                    continue;
                                }
                                dwnpatch_logger.log(Level.DEBUG, "Counter  :: " + (i + 1));
                                dwnpatch_logger.log(Level.INFO, "Initiating patch download: " + patchName);
                                long l = patchId = request.has("PATCHID") ? request.getLong("PATCHID") : request.getLong("FILE_ID");
                                if (uploadPatchesList != null && uploadPatchesList.contains(patchId)) {
                                    dwnpatch_logger.log(Level.INFO, patchName + " requires manual upload. Refer to this read KB: ");
                                    continue;
                                }
                                proxyserver.processDownloadRequest(request);
                            }
                            if (pkgCount > 0) {
                                dwnpatch_logger.info("Total package count: " + pkgCount);
                                for (i = 0; i < pkgCount; ++i) {
                                    request = jsonArray1.getJSONObject(i);
                                    String pkgName = request.getString("PACKAGE_NAME");
                                    dwnpatch_logger.info("Initiating package download: " + pkgName);
                                    proxyserver.processDownloadRequestPkgs(request);
                                }
                            }
                            if ((officePatchLength = (officePatchActions = requestObject.has("actions") ? requestObject.getJSONObject("actions") : new JSONObject()).length()) > 0 && isWindows) {
                                officepatch_logger.log(Level.INFO, "The missing patch list includes Microsoft office patches, and their execution has started");
                                if (officePatchActionsHandler.preReqDepCheckAndDownload()) {
                                    HashMap<String, ArrayList<Long>> map = officePatchActionsHandler.performOfficePatchActions(requestObject);
                                    int failedOfficeCount = 0;
                                    ArrayList<Long> failedInRunCommand = map.get("failedInRunCommand");
                                    ArrayList<Long> failedInOtherActions = map.get("failedInOtherActions");
                                    if (failedInRunCommand != null) {
                                        failedOfficeCount += failedInRunCommand.size();
                                    }
                                    if (failedInOtherActions != null) {
                                        failedOfficeCount += failedInOtherActions.size();
                                    }
                                    if (failedOfficeCount > 0) {
                                        if (failedInRunCommand != null && !failedInRunCommand.isEmpty()) {
                                            officepatch_logger.log(Level.INFO, "Failed to download Microsoft Office patches for Patch IDs " + failedInRunCommand.toString() + ". Refer to the troubleshooting document below to resolve the issue.");
                                            officepatch_logger.log(Level.INFO, "Link: https://www.manageengine.com/patch-management/knowledge-base/office-365-patch-download-failure.html");
                                        }
                                        if (failedInOtherActions != null && !failedInOtherActions.isEmpty()) {
                                            officepatch_logger.log(Level.INFO, "Failed to generate the package for Microsoft Office patches with Patch IDs: " + failedInOtherActions.toString() + ". Please contact support for assistance.");
                                        }
                                        success -= failedOfficeCount;
                                        fail += failedOfficeCount;
                                        officepatch_logger.info("Check the following logs for more details: ");
                                        officepatch_logger.info("<TOOL_HOME>\\logs\\officepatch_logger.log\n");
                                    } else {
                                        officepatch_logger.log(Level.INFO, "Download of all Microsoft Office patches has been completed successfully");
                                    }
                                } else {
                                    officepatch_logger.log(Level.INFO, "Download of all Microsoft Office patches has been Skipped due to Missing Dependent Files.");
                                }
                            } else if (officePatchLength > 0) {
                                dwnpatch_logger.info("Linux OS flavors do not support Office patches.");
                            }
                            int totalCount = patchCount + pkgCount;
                            int skipped = totalCount - (success + fail);
                            if (fail > 0) {
                                dwnpatch_logger.info("Download status : Failed");
                                dwnpatch_logger.info("Total number of patches downloaded successfully: " + success);
                                dwnpatch_logger.info("Total number of skipped patches during download: " + skipped);
                                dwnpatch_logger.info("Total number of patches that failed to download: " + fail);
                                dwnpatch_logger.info("Patch download failed. Check the following logs for more details: ");
                                dwnpatch_logger.info("<TOOL_HOME>downloadRemarks.txt");
                                dwnpatch_logger.info("<TOOL_HOME>\\logs\\dwnload_tool_log.log\n");
                            } else {
                                dwnpatch_logger.info("Download status : Success");
                                dwnpatch_logger.info("Total number of patches downloaded successfully: " + success);
                                dwnpatch_logger.info("Total number of skipped patches during download: " + skipped);
                                dwnpatch_logger.info("Total number of patches that failed to download: " + fail);
                            }
                        } else {
                            dwnpatch_logger.info("No missing patch details found.");
                        }
                    } else {
                        dwnpatch_logger.info("The downloadUrlJson.txt file is missing in the <TOOL_HOME> directory. Refer to this read KB: <https://www.manageengine.com/patch-management/help/patch-management-for-closed-network.html#config>");
                    }
                } else {
                    proxyserver.displayHelp();
                }
            }
            catch (Exception exp) {
                dwnpatch_logger.error(exp.getMessage());
            }
        }
    }

    public void displayHelp() {
        LOGGER.debug("Command Usage : patchsync.bat -c updatedb -b <BUILD_NUMBER>");
        LOGGER.debug("Command Usage : patchsync.bat -c updatedb -i linux -b <BUILD_NUMBER>");
        LOGGER.debug("Command Usage : patchsync.bat -c dwnpatch -f downloadUrlJson.txt");
        LOGGER.debug("Command Usage : patchsync.bat -c toolUpgrade");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProxySettings() {
        Properties proxyProperties = null;
        FileInputStream pis = null;
        String proxyFileName = "downloadMgr.prop";
        try {
            if (new File(proxyFileName).exists()) {
                pis = new FileInputStream(proxyFileName);
                proxyProperties = new Properties();
                proxyProperties.load(pis);
                dwnManager.setProxyConfiguration(proxyProperties);
            }
        }
        catch (Exception exp) {
            LOGGER.error(exp.getMessage());
        }
        finally {
            if (pis != null) {
                try {
                    pis.close();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return proxyProperties;
    }

    private JSONObject loadDownloadJson(String jsonFileName) throws Exception {
        JSONObject requestObject = null;
        try {
            FileInputStream fis = null;
            byte[] content = null;
            try {
                if (new File(jsonFileName).exists()) {
                    fis = new FileInputStream(jsonFileName);
                    content = new byte[fis.available()];
                    fis.read(content);
                    String jsonString = new String(content);
                    requestObject = new JSONObject(jsonString);
                } else {
                    LOGGER.debug("Command Usage :Enter Valid File");
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
                throw e;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception exp) {
            LOGGER.error(exp.getMessage());
        }
        return requestObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processUpdateDBRequest(String[] args, String buildNumber, JSONObject syncModuleDetailsJSON) {
        int modId = -1;
        String latestFile = "";
        try {
            String destinationFile = "updatedb" + File.separator + "dc-crs" + File.separator + "crs-meta-data.xml";
            DownloadStatus dwnStatus = null;
            if (new File(destinationFile).exists()) {
                File mainMetaFile = new File(destinationFile);
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                domFactory.setNamespaceAware(true);
                DocumentBuilder builder = domFactory.newDocumentBuilder();
                Document doc = builder.parse(mainMetaFile);
                XPath xpath = XPathFactory.newInstance().newXPath();
                String expression = "//CRSMetaData";
                XPathExpression expr = xpath.compile(expression);
                Object result = expr.evaluate(doc, XPathConstants.NODESET);
                NodeList nodeList = (NodeList)result;
                int modulesCount = nodeList.getLength();
                int downloadingCount = 0;
                HashMap<String, String> downloadModules = null;
                if (Long.parseLong(buildNumber) >= 101222801L) {
                    updatedb_logger.log(Level.DEBUG, "Going to download required schema versions");
                    downloadModules = DCDownloadMgrProxyServer.getDownloadModules(syncModuleDetailsJSON, buildNumber);
                    if (downloadModules != null) {
                        updatedb_logger.log(Level.DEBUG, "Sync module details : " + downloadModules);
                        modulesCount = downloadModules.size();
                    }
                } else {
                    updatedb_logger.log(Level.DEBUG, "Going to download all schema versions");
                }
                int success = 0;
                int failed = 0;
                updatedb_logger.log(Level.INFO, "Initiating files download from the Patch Repository.");
                updatedb_logger.log(Level.DEBUG, "Modules count : " + modulesCount);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    int moduleId;
                    boolean downloadModule;
                    boolean flag = false;
                    Node nodes = nodeList.item(i);
                    NamedNodeMap attributes = nodes.getAttributes();
                    String crsMetaDataKey = attributes.getNamedItem("crs_meta_data_key").getNodeValue();
                    String schemaVersion = attributes.getNamedItem("schema_version").getNodeValue();
                    boolean bl = downloadModule = downloadModules == null || downloadModules.containsKey(crsMetaDataKey) && downloadModules.get(crsMetaDataKey).equals(schemaVersion);
                    if (!downloadModule) {
                        updatedb_logger.log(Level.DEBUG, "skipping download for module :: " + crsMetaDataKey + " and schema version :: " + schemaVersion);
                        continue;
                    }
                    String crsFileName = attributes.getNamedItem("crs_meta_data_file_name").getNodeValue();
                    String crsFilePath = attributes.getNamedItem("crs_meta_data_file_path").getNodeValue();
                    String checksum = attributes.getNamedItem("checksum").getNodeValue();
                    String checksumType = attributes.getNamedItem("checksum_type").getNodeValue();
                    updatedb_logger.log(Level.DEBUG, "Downloading module :" + ++downloadingCount);
                    updatedb_logger.log(Level.INFO, "Downloading files for " + crsMetaDataKey + " module");
                    updatedb_logger.log(Level.DEBUG, "Schema Version : " + schemaVersion);
                    if (crsFileName.equalsIgnoreCase("linux-details.xml") && (moduleId = Integer.valueOf(attributes.getNamedItem("crs_module_id").getNodeValue()).intValue()) > modId) {
                        flag = true;
                        modId = moduleId;
                    }
                    Boolean isReqFile = Boolean.TRUE;
                    ArrayList<String> unwantedFilesList = new ArrayList<String>();
                    unwantedFilesList.add("software-details.xml");
                    unwantedFilesList.add("software-package.xml");
                    unwantedFilesList.add("script-repository.xml");
                    if (unwantedFilesList.contains(crsFileName)) {
                        updatedb_logger.log(Level.DEBUG, "Skipped Download for " + crsFileName);
                        isReqFile = Boolean.FALSE;
                    }
                    if (isReqFile.booleanValue()) {
                        String destinationDetailsFile;
                        String defDetailsUrl = "https://patchdb.manageengine.com//" + crsFilePath + "/" + crsFileName;
                        dwnStatus = dwnManager.downloadFileWithCheckSumValidation(defDetailsUrl, destinationDetailsFile = "updatedb" + File.separator + crsFilePath + File.separator + crsFileName, checksum, checksumType, null, null, new SSLValidationType[0]);
                        if (dwnStatus.getStatus() != 0) {
                            updatedb_failed_logger.log(Level.INFO, "Downloading failed for file " + crsFileName + " of " + crsMetaDataKey + " module.");
                        } else if (!crsFileName.endsWith(".json")) {
                            File file = new File(destinationDetailsFile);
                            DocumentBuilder defBuilder = domFactory.newDocumentBuilder();
                            Document defDoc = defBuilder.parse(file);
                            XPath defxpath = XPathFactory.newInstance().newXPath();
                            String defExpression = "//DefinitionMetaData";
                            XPathExpression defExpr = defxpath.compile(defExpression);
                            Object defResult = defExpr.evaluate(defDoc, XPathConstants.NODESET);
                            NodeList defNodeList = (NodeList)defResult;
                            for (int j = 0; j < defNodeList.getLength(); ++j) {
                                Node defNodes = defNodeList.item(j);
                                NamedNodeMap defAttributes = defNodes.getAttributes();
                                String dataFilePath = defAttributes.getNamedItem("definition_file_path").getNodeValue();
                                String dataFileName = defAttributes.getNamedItem("definition_file_name").getNodeValue();
                                checksum = defAttributes.getNamedItem("checksum").getNodeValue();
                                checksumType = defAttributes.getNamedItem("checksum_type").getNodeValue();
                                if (flag && dataFileName.equalsIgnoreCase("linux-detail.sql")) {
                                    latestFile = "updatedb" + File.separator + dataFilePath + File.separator + dataFileName;
                                }
                                String is_diff_sql = "true";
                                Node node = defAttributes.getNamedItem("is_diff_sql");
                                is_diff_sql = node == null ? "false" : "true";
                                String sqlDestinationFile = "updatedb" + File.separator + dataFilePath + File.separator + dataFileName;
                                String sqlDownloadUrl = CRSURL + dataFilePath + "/" + dataFileName;
                                if (!is_diff_sql.equalsIgnoreCase("false")) continue;
                                DownloadStatus status = dwnManager.downloadFileWithCheckSumValidation(sqlDownloadUrl, sqlDestinationFile, checksum, checksumType, null, null, new SSLValidationType[0]);
                                if (status.getStatus() == 0) {
                                    ++success;
                                    updatedb_logger.log(Level.DEBUG, "Downloaded " + dataFileName + " file of " + crsFileName + " module");
                                    continue;
                                }
                                ++failed;
                                updatedb_failed_logger.log(Level.INFO, "Downloading failed for file " + dataFileName + " of " + crsMetaDataKey + " module");
                            }
                        }
                    }
                    if (downloadModules == null) continue;
                    downloadModules.remove(crsMetaDataKey);
                }
                updatedb_logger.log(Level.INFO, "");
                if (failed > 0) {
                    updatedb_logger.log(Level.INFO, "Download status : Failed");
                    updatedb_logger.log(Level.INFO, "Total number of files downloaded successfully : " + success);
                    updatedb_logger.log(Level.INFO, "Total number of files that failed to download: " + failed);
                    updatedb_logger.log(Level.INFO, "File download failed. Check the following logs for more details: ");
                    updatedb_logger.log(Level.INFO, "<TOOL_HOME>\\logs\\dwnload_tool_log.log ");
                    updatedb_logger.log(Level.INFO, "<TOOL_HOME>\\logs\\updatedb_dwn_failed_status.log");
                } else {
                    updatedb_logger.log(Level.INFO, "Download status : Success");
                    updatedb_logger.log(Level.INFO, "Total number of files downloaded successfully : " + success);
                    updatedb_logger.log(Level.INFO, "Total number of files that failed to download: " + failed);
                }
                updatedb_logger.log(Level.INFO, "");
                if (downloadModules != null && !downloadModules.isEmpty()) {
                    for (String moduleName : downloadModules.keySet()) {
                        updatedb_logger.log(Level.WARN, "The required Vulnerability DB sync files for " + moduleName + " module is not available in Patch Repository. ");
                    }
                }
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("headless-chrome", "HeadlessChrome.zip") == 1) {
                updatedb_logger.log(Level.INFO, "HeadlessChrome.zip downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "HeadlessChrome.zip download failed");
            }
            if (Long.parseLong(buildNumber) >= 113241801L) {
                if (DCDownloadMgrProxyServer.downloadMetaDataFiles("uems-chrome-package", "UEMS-ChromePackage.zip") == 1) {
                    updatedb_logger.log(Level.INFO, "UEMS-ChromePackage.zip downloaded successfully");
                } else {
                    updatedb_failed_logger.log(Level.INFO, "UEMS-ChromePackage.zip download failed");
                }
            } else if (DCDownloadMgrProxyServer.downloadMetaDataFiles("chrome-package", "chrome-package.zip") == 1) {
                updatedb_logger.log(Level.INFO, "chrome-package.zip downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "chrome-package.zip download failed");
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("os-detection", "OSDetection.json") == 1) {
                updatedb_logger.log(Level.INFO, "os-detection downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "os-detection download failed");
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("os-detection-gz", "OSDetection.json.gz") == 1) {
                updatedb_logger.log(Level.INFO, "os-detection-gz downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "os-detection-gz download failed");
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("dbsync-stop", "dbsync-details.json") == 1) {
                updatedb_logger.log(Level.INFO, "dbsync-details.json downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "dbsync-details.json download failed");
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("crawler-table-details", "crawler_table_details.json") == 1) {
                updatedb_logger.log(Level.INFO, "crawler_table_details.json downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "crawler_table_details.json download failed");
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("upload-patches", "upload-patches.json") == 1) {
                updatedb_logger.log(Level.INFO, "upload-patches.json downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "upload-patches.json download failed");
            }
            if (DCDownloadMgrProxyServer.downloadMetaDataFiles("network-device-scandata", "NetworkDeviceScanData.json") == 1) {
                updatedb_failed_logger.log(Level.INFO, "NetworkDeviceScanData.json downloaded successfully");
            } else {
                updatedb_failed_logger.log(Level.INFO, "NetworkDeviceScanData.json downloaded failed");
            }
        }
        catch (Exception exp) {
            updatedb_logger.error((Object)exp);
        }
        finally {
            if (latestFile != null && latestFile.length() != 0) {
                updatedb_logger.debug("Latest File is " + latestFile);
            }
        }
        if (args.length == 6 && args[2].equals("-i") && args[3].equals("linux")) {
            updatedb_logger.log(Level.INFO, "Initiating Linux Package Manager Files download");
            LinuxOffline.parse(latestFile);
            updatedb_logger.log(Level.INFO, "Linux Package Manager Files download completed");
        }
    }

    public void processDownloadRequestPkgs(JSONObject requestObject) {
        try {
            String downloadUrl = requestObject.getString("URL");
            String pkgID = requestObject.getString("PACKAGE_ID");
            String pkgName = requestObject.getString("PACKAGE_NAME");
            int flavorID = Integer.parseInt(requestObject.getString("FLAVOR_ID"));
            String category = LinuxFlavor.getLinuxCategory(flavorID) + "-dependencies";
            String destinationFile = "store" + File.separator + "linux" + File.separator + category + File.separator + pkgName;
            File f = new File(destinationFile);
            if (f.exists()) {
                dwnpatch_logger.debug("File already exists. Download skipped..");
                return;
            }
            DownloadStatus dwnStatus = dwnManager.downloadFile(downloadUrl, destinationFile);
            int statusCode = dwnStatus.getStatus();
            dwnpatch_logger.debug("Download Status : " + (statusCode == 0 ? "SUCCESS" : "FAILED"));
            dwnpatch_logger.debug("Download Package Name : " + pkgName);
            if (statusCode == 0) {
                ++success;
                dwnpatch_logger.log(Level.DEBUG, "Downloaded " + pkgName + " package successfully");
            } else {
                ++fail;
                String content = "Package: " + pkgID + "\t" + pkgName + "\t" + downloadUrl;
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File("downloadRemarks.txt"), true));
                bw.write(content);
                bw.newLine();
                bw.close();
                dwnpatch_failed_logger.log(Level.INFO, "Downloading " + pkgName + " package has failed");
                dwnpatch_failed_logger.log(Level.DEBUG, "Details :: " + content);
            }
        }
        catch (Exception exp) {
            dwnpatch_logger.error(exp.getMessage());
        }
    }

    public void processDownloadRequest(JSONObject requestObject) {
        try {
            String downloadUrl = null;
            if (requestObject.has("PATH")) {
                downloadUrl = requestObject.getString("PATH");
            } else if (requestObject.has("DOWNLOAD_URL")) {
                downloadUrl = requestObject.getString("DOWNLOAD_URL");
            }
            String patchID = null;
            String fileName = null;
            String destinationFile = null;
            if (requestObject.has("PATCHNAME")) {
                patchID = requestObject.getString("PATCHID");
                fileName = requestObject.getString("PATCHNAME");
                destinationFile = "store" + File.separator + patchID + "-" + fileName;
            } else if (requestObject.has("FILE_NAME")) {
                fileName = requestObject.getString("FILE_NAME");
                destinationFile = "store" + File.separator + fileName;
            }
            if (fileName == null) {
                dwnpatch_logger.log(Level.ERROR, "filename is null");
                return;
            }
            if (downloadUrl == null) {
                dwnpatch_logger.log(Level.ERROR, "downloadUrl is null");
                return;
            }
            File f = new File(destinationFile);
            if (f.exists()) {
                dwnpatch_logger.debug("File already exists. Download Skipped.");
                return;
            }
            DownloadStatus dwnStatus = dwnManager.downloadFile(downloadUrl, destinationFile);
            int statusCode = dwnStatus.getStatus();
            dwnpatch_logger.debug("Download Status : " + (statusCode == 0 ? "SUCCESS" : "FAILED"));
            dwnpatch_logger.debug("Download Patch Name : " + fileName);
            if (statusCode == 0) {
                ++success;
                dwnpatch_logger.log(Level.DEBUG, "Downloaded " + fileName + " patch file successfully");
            } else {
                ++fail;
                String content = "Patch: " + patchID + "\t" + fileName + "\t" + downloadUrl;
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File("downloadRemarks.txt"), true));
                bw.write(content);
                bw.newLine();
                bw.close();
                dwnpatch_failed_logger.log(Level.INFO, "Downloading " + fileName + " patch file has failed");
                dwnpatch_failed_logger.log(Level.DEBUG, "Details :: " + content);
            }
        }
        catch (Exception exp) {
            dwnpatch_logger.error(exp.getMessage());
        }
    }

    public static int verifyDownloadUrl(JSONObject syncModuleDetailsJSON) throws Exception {
        int verified;
        block9: {
            String destinationFile;
            String metaFileUrl = syncModuleDetailsJSON.getString("metaFileUrl");
            downloadUrl = CRSURL + metaFileUrl;
            File tempFile = new File("temp");
            if (!tempFile.exists()) {
                tempFile.mkdir();
            }
            if (new File(destinationFile = "temp" + File.separator + "DBSyncMeta.json").exists()) {
                new File(destinationFile).delete();
            }
            DownloadStatus dwnStatus = dwnManager.downloadFile(downloadUrl, destinationFile);
            verified = 0;
            byte[] unSignedContent = null;
            if (dwnStatus.getStatus() == 0) {
                try {
                    unSignedContent = new CRTThumbPrintVerifier().verifyAndUNSignFileContentWithMEMetaCrt(destinationFile);
                    File file = null;
                    if (unSignedContent == null) break block9;
                    file = new File("temp" + File.separator + "UnsignedContent.json");
                    if (file.exists()) {
                        file.delete();
                    }
                    FileWriter fw = new FileWriter(file);
                    for (int unsign = 0; unsign < unSignedContent.length; ++unsign) {
                        fw.write(unSignedContent[unsign]);
                    }
                    fw.close();
                    if (file.exists()) {
                        verified = 1;
                    }
                }
                catch (Exception exp) {
                    LOGGER.error(exp.getMessage());
                }
            } else {
                LOGGER.error("Download failed for " + downloadUrl + ". Download status= " + dwnStatus.getStatus());
            }
        }
        return verified;
    }

    private static StringBuilder readFileFromUnsignedContentJson() {
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            FileReader fr = new FileReader("temp" + File.separator + "UnsignedContent.json");
            while ((i = fr.read()) != -1) {
                sb.append((char)i);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return sb;
    }

    public static int downloadMetaDataFiles(String fileKey, String fileName) {
        String pathName = null;
        String checksum = null;
        String checksumType = null;
        int valid = 0;
        try {
            StringBuilder sb = DCDownloadMgrProxyServer.readFileFromUnsignedContentJson();
            JSONTokener tokener = new JSONTokener(sb.toString());
            JSONObject object = new JSONObject(tokener);
            JSONObject metaconfig = object.getJSONObject("META_CONFIG");
            checksumType = (String)metaconfig.get("checksum_type");
            JSONObject meta = object.getJSONObject("META_PROPERTIES");
            JSONObject path = meta.getJSONObject(fileKey);
            checksum = (String)path.get("checksum");
            pathName = (String)path.get("file_path");
            downloadUrl = CRSURL + pathName;
            String destinationFile = "updatedb" + File.separator + "dc-crs" + File.separator + fileName;
            try {
                DownloadStatus status = dwnManager.downloadFileWithCheckSumValidation(downloadUrl, destinationFile, checksum, checksumType, null, null, new SSLValidationType[0]);
                if (status.getStatus() == 0) {
                    valid = 1;
                    updatedb_logger.debug("Successfully downloaded " + fileName + " file");
                }
            }
            catch (Exception e) {
                updatedb_logger.error("Download failed for " + downloadUrl + ":  " + e.getMessage());
            }
        }
        catch (Exception e) {
            updatedb_logger.error((Object)e);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadUpgradeFile() {
        Properties properties;
        block19: {
            properties = new Properties();
            FileInputStream pis = null;
            String fileName = "autoUpgrade.prop";
            try {
                if (new File(fileName).exists()) {
                    pis = new FileInputStream(fileName);
                    properties.load(pis);
                    break block19;
                }
                try (FileOutputStream fileOutputStream = null;){
                    properties.put("version", "0");
                    properties.put("autoUpgrade", "true");
                    fileOutputStream = new FileOutputStream("autoUpgrade.prop");
                    properties.store(fileOutputStream, "props file for autougrade process");
                }
            }
            catch (Exception exp) {
                LOGGER.error(exp.getMessage());
            }
            finally {
                if (pis != null) {
                    try {
                        pis.close();
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        return properties;
    }

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                DCDownloadMgrProxyServer.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdirs();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
        Files.deleteIfExists(Paths.get("upgrade/UpdateManager.zip", new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(filePath));
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                ((BufferedOutputStream)bos).write(bytesIn, 0, read);
            }
        }
    }

    public ArrayList<Long> getUploadPatchesList(JSONObject uploadPatchJSON) {
        ArrayList<Long> patchList = null;
        if (uploadPatchJSON != null) {
            patchList = new ArrayList<Long>();
            try {
                JSONObject uploadPatchData = uploadPatchJSON.getJSONObject("upload_patches");
                Iterator keyItr = uploadPatchData.keys();
                while (keyItr.hasNext()) {
                    String keyName = (String)keyItr.next();
                    JSONObject patchJSON = uploadPatchData.getJSONObject(keyName);
                    JSONArray patchesArray = patchJSON.getJSONArray("patch_id");
                    for (int i = 0; i < patchesArray.length(); ++i) {
                        patchList.add(patchesArray.getLong(i));
                    }
                }
            }
            catch (JSONException e) {
                dwnpatch_logger.log(Level.ERROR, "Error while fetching data from upload patch json ", (Throwable)e);
            }
            catch (Exception e) {
                dwnpatch_logger.log(Level.ERROR, "Exception occurred in getUploadPatchesList --> {0}", (Throwable)e);
            }
        }
        return patchList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getSyncModulesJSON(String fileName) {
        JSONObject downloadModules = null;
        if (fileName != null && !fileName.isEmpty()) {
            File crsModuleJsonFile = new File(fileName);
            if (crsModuleJsonFile.exists()) {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(crsModuleJsonFile);
                    byte[] jsonContent = new byte[inputStream.available()];
                    inputStream.read(jsonContent);
                    String jsonContentStr = new String(jsonContent);
                    downloadModules = new JSONObject(jsonContentStr);
                }
                catch (FileNotFoundException e) {
                    updatedb_logger.log(Level.ERROR, "Given " + fileName + " file not found ", (Throwable)e);
                }
                catch (IOException e) {
                    updatedb_logger.log(Level.ERROR, "Exception occurred while reading " + fileName, (Throwable)e);
                }
                catch (JSONException e) {
                    updatedb_logger.log(Level.ERROR, "Unable to parse the file content (" + fileName + ") as JSON", (Throwable)e);
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            updatedb_logger.log(Level.ERROR, "Unable to close File input stream");
                        }
                    }
                }
            } else {
                updatedb_logger.log(Level.INFO, fileName + " is missing.");
            }
        }
        return downloadModules;
    }

    public static HashMap<String, String> getDownloadModules(JSONObject syncModuleJSON, String buildVersion) {
        HashMap<String, String> moduleDetails = null;
        if (syncModuleJSON != null) {
            long buildNumber = Long.parseLong(buildVersion);
            moduleDetails = new HashMap<String, String>();
            try {
                JSONObject syncModuleDetails = syncModuleJSON.getJSONObject("SyncModules");
                Iterator moduleItr = syncModuleDetails.keys();
                while (moduleItr.hasNext()) {
                    String moduleName = (String)moduleItr.next();
                    String schemaVersion = "";
                    JSONObject schemaDetails = syncModuleDetails.getJSONObject(moduleName);
                    Iterator schemaVerKeyItr = schemaDetails.keys();
                    while (schemaVerKeyItr.hasNext()) {
                        String curSchemaVersion = (String)schemaVerKeyItr.next();
                        String curBuildVersion = schemaDetails.getString(curSchemaVersion);
                        String[] buildVersionRanges = curBuildVersion.split(",");
                        for (int rangeIndx = 0; rangeIndx < buildVersionRanges.length; ++rangeIndx) {
                            long curBaseBuildNumber;
                            long curToBuildNumber = 0L;
                            String curBuildRange = buildVersionRanges[rangeIndx];
                            if (curBuildRange.contains("-")) {
                                String[] curBuildVersionRange = buildVersionRanges[rangeIndx].split("-");
                                curBaseBuildNumber = Long.parseLong(curBuildVersionRange[0]);
                                curToBuildNumber = curBuildVersionRange.length > 1 ? Long.parseLong(curBuildVersionRange[1]) : -1L;
                            } else {
                                curBaseBuildNumber = Long.parseLong(curBuildRange);
                            }
                            if ((curToBuildNumber != 0L || curBaseBuildNumber != buildNumber) && (curBaseBuildNumber > buildNumber || curToBuildNumber != -1L && curToBuildNumber < buildNumber)) continue;
                            schemaVersion = curSchemaVersion;
                        }
                    }
                    if (schemaVersion.isEmpty()) continue;
                    moduleDetails.put(moduleName, schemaVersion);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return moduleDetails;
    }

    public static String parseBuildNumber(String buildVersion) {
        if (buildVersion != null && !buildVersion.isEmpty() && buildVersion.matches("^\\d{2}.\\d.\\d{4}.\\d{1,2}|\\d{6,9}$")) {
            if (buildVersion.contains(".")) {
                String[] buildVersionDetails = buildVersion.split("\\.");
                StringBuilder newBuildVersion = new StringBuilder();
                newBuildVersion.append(buildVersionDetails[0]);
                newBuildVersion.append(buildVersionDetails[1]);
                newBuildVersion.append(buildVersionDetails[2]);
                String tempVersion = buildVersionDetails[3];
                if (tempVersion.length() < 2) {
                    tempVersion = "0".concat(tempVersion);
                }
                newBuildVersion.append(tempVersion);
                buildVersion = newBuildVersion.toString();
            }
            return buildVersion;
        }
        return null;
    }

    public Boolean deleteFilesInDirectory(String dirPath, boolean excludeDirectory) throws Exception {
        File path = new File(dirPath);
        if (path.isFile()) {
            return path.delete();
        }
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteFilesInDirectory(files[i].toString(), false);
                    continue;
                }
                files[i].delete();
            }
        }
        if (excludeDirectory) {
            return null;
        }
        return path.delete();
    }
}

