/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.server.downloadmgr;

import com.adventnet.sym.server.downloadmgr.DCDownloadMgrProxyServer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import javax.xml.bind.DatatypeConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.util.CollectionStore;

public class CRTThumbPrintVerifier {
    private static final Logger LOGGER = LogManager.getLogger(DCDownloadMgrProxyServer.class);

    public boolean verify(byte[] data, Certificate certificate) throws Exception {
        return this.verify(data, this.getThumbPrint(certificate));
    }

    public boolean verify(byte[] data, String thumbPrint) throws Exception {
        CMSSignedData signedData = new CMSSignedData(data);
        CollectionStore certificatesStore = (CollectionStore)signedData.getCertificates();
        Collection collection = certificatesStore.getMatches(null);
        if (!collection.isEmpty()) {
            Object obj = collection.iterator().next();
            X509CertificateHolder holder = (X509CertificateHolder)obj;
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(holder.getEncoded());
            Certificate certificate = certFactory.generateCertificate(inputStream);
            String signedThumbPrint = this.getThumbPrint(certificate);
            return thumbPrint.equals(signedThumbPrint);
        }
        return false;
    }

    public byte[] getUNSignedContent(byte[] signedContent) throws Exception {
        CMSSignedData signedData = new CMSSignedData(signedContent);
        CMSTypedData processable = signedData.getSignedContent();
        return this.getUNSignedContent((CMSProcessable)processable);
    }

    public byte[] getUNSignedContent(CMSProcessable processable) throws Exception {
        Object processableContent;
        if (processable != null && (processableContent = processable.getContent()) != null) {
            if (processableContent instanceof byte[]) {
                byte[] processableBytes = (byte[])processableContent;
                if (processableBytes.length > 0) {
                    return processableBytes;
                }
                return null;
            }
            LOGGER.error("Illegal content of type " + processableContent.getClass().getCanonicalName());
        }
        return null;
    }

    public String getThumbPrint(Certificate cert) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        String digestHex = DatatypeConverter.printHexBinary((byte[])digest);
        return digestHex.toLowerCase();
    }

    public byte[] verifyAndUNSignFileContentWithMEMetaCrt(String filePath) {
        try {
            byte[] signedContent = CRTThumbPrintVerifier.getFileAsByteArray(filePath);
            if (signedContent != null) {
                if (this.verify(signedContent, "9d4b262c221ea23ad8e66c912b58c43156ec255cd3d2e05e0117883f46d8e40d")) {
                    LOGGER.debug("File verified with MEMeta crt tp");
                    return this.getUNSignedContent(signedContent);
                }
                LOGGER.error("File verify failed with MEMeta crt tp");
            } else {
                LOGGER.error("File content available to verify with MEMeta crt tp.");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage() + ": Exception occurred while unsigning file with MEMeta crt tp");
        }
        return null;
    }

    public static byte[] getFileAsByteArray(String filePath) {
        byte[] fileByte = null;
        try {
            BufferedInputStream fileInput = new BufferedInputStream(new FileInputStream(filePath));
            fileByte = new byte[((InputStream)fileInput).available()];
            ((InputStream)fileInput).read(fileByte);
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("FileNotFoundException while getFileAsInputStream " + ex.getMessage());
        }
        catch (IOException ex) {
            LOGGER.error("IOException while getFileAsInputStream " + ex.getMessage());
        }
        return fileByte;
    }
}

