/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.downloadutils;

import com.adventnet.downloadutils.ChecksumProvider;
import com.adventnet.downloadutils.CustomResponseHandler;
import com.adventnet.downloadutils.DownloadStatus;
import com.adventnet.downloadutils.SSLValidationType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.util.Timeout;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadManager {
    public static DownloadManager dwnmgr = null;
    private static final Logger LOGGER = LogManager.getLogger(DownloadManager.class);
    private static final Logger STATUS_LOGGER = LogManager.getLogger((String)"STATUS_LOGGER");
    private Properties proxydetails = null;
    private String proxyProtocol = "HTTP";
    private static int connectionTimeOut = 180000;
    private static int retryCount = 2;
    private static int checksumValidationFile = 0;
    private static ArrayList<String> enforceHttpsList = new ArrayList();
    private static ArrayList<String> defaultSSLValidationDomainList = new ArrayList();

    public static DownloadManager getInstance() {
        if (dwnmgr == null) {
            dwnmgr = new DownloadManager();
        }
        return dwnmgr;
    }

    public void setProxyConfiguration(Properties proxyProp) {
        this.proxydetails = proxyProp;
    }

    public DownloadStatus downloadFile(String sourceFile, String destinationFile) {
        return this.downloadFile(sourceFile, destinationFile, null, false);
    }

    private DownloadStatus downloadFile(String sourceFile, String destinationFile, Properties headers, boolean isBinary) {
        DownloadStatus status = new DownloadStatus(10008);
        try {
            LOGGER.debug("Going to establish connecton for " + sourceFile);
            String userAgent = System.getProperty("http.agent");
            if (userAgent == null) {
                userAgent = "ManageEngine Desktop Central";
            }
            if (headers == null) {
                headers = new Properties();
            }
            if (!headers.containsKey("User-Agent")) {
                headers.put("User-Agent", userAgent);
            }
            return this.getHttpResponse(sourceFile, destinationFile, 1, this.proxydetails, headers, isBinary, status, new SSLValidationType[0]);
        }
        catch (URISyntaxException usep) {
            LOGGER.error("File : " + sourceFile + " failed to download with error code:" + 901);
            LOGGER.warn("Exception trace: ", (Throwable)usep);
            status.errMessage = usep.getMessage();
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("File : " + sourceFile + " failed to download with error code:" + 902);
            LOGGER.warn("Exception trace: ", (Throwable)iae);
            status.errMessage = iae.getMessage();
        }
        catch (FileNotFoundException fexp) {
            LOGGER.error("File : " + sourceFile + " failed with error code:" + 903);
            LOGGER.warn("Exception trace: ", (Throwable)fexp);
            status.errMessage = fexp.getMessage();
        }
        catch (IOException ex) {
            LOGGER.error("File : " + sourceFile + " failed with error code:" + 904);
            LOGGER.warn("Exception trace: ", (Throwable)ex);
            status.errMessage = ex.getMessage();
        }
        catch (Exception exp) {
            LOGGER.error("File : " + sourceFile + " failed with error code:" + 905);
            LOGGER.warn("Exception trace: ", (Throwable)exp);
            status.errMessage = exp.getMessage();
        }
        return status;
    }

    private DownloadStatus getHttpResponse(String sourceFile, String destinationFile, int counter, Properties proxydetails, Properties headers, boolean isBinary, DownloadStatus status, SSLValidationType ... validationTypes) throws Exception {
        if (sourceFile != null) {
            ArrayList sslValidationTypes;
            String theUrl = sourceFile;
            boolean reDownload = false;
            List<Object> list = validationTypes == null ? new ArrayList() : (sslValidationTypes = validationTypes.length == 0 ? this.getDownloadManagerDefaultSSLValidations(sourceFile) : Arrays.asList(validationTypes));
            if (sslValidationTypes.contains((Object)SSLValidationType.ENFORCE_HTTPS)) {
                LOGGER.debug("ENFORCE_HTTPS");
                String string = theUrl = new URL(theUrl).getProtocol().equalsIgnoreCase("http") ? sourceFile.replaceFirst("http", "https") : sourceFile;
            }
            if ((theUrl = theUrl.replaceAll("(?<!:)//+", "/")).contains(" ")) {
                theUrl = theUrl.replaceAll("\\s", "%20");
            }
            HttpGet request = new HttpGet(theUrl);
            if (headers != null) {
                this.setHeadersData(headers, request);
            }
            try (CloseableHttpClient connection = this.getConnection(theUrl, proxydetails, sslValidationTypes.contains((Object)SSLValidationType.DEFAULT_SSL_VALIDATION));){
                connection.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new CustomResponseHandler(sourceFile, destinationFile, isBinary, status));
                LOGGER.debug("Response for URL " + sourceFile + " is : " + status.getStatus());
                if (status.getStatus() == 503) {
                    ++counter;
                    reDownload = true;
                }
            }
            catch (Exception ex) {
                if (sslValidationTypes.contains((Object)SSLValidationType.RETRY_ACTUAL_WITHOUT_VALIDATION)) {
                    LOGGER.debug("Download failed, Going to retry again one more time without ssl validation." + sourceFile);
                    sourceFile = sourceFile.replaceAll("(?<!:)//+", "/");
                    if (sourceFile.contains(" ")) {
                        sourceFile = sourceFile.replaceAll("\\s", "%20");
                    }
                    try (CloseableHttpClient connection2 = this.getConnection(sourceFile, proxydetails, false);){
                        connection2.execute((ClassicHttpRequest)request, (HttpClientResponseHandler)new CustomResponseHandler(sourceFile, destinationFile, isBinary, status));
                    }
                }
                throw ex;
            }
            if (reDownload && counter <= retryCount) {
                Thread.sleep(5000L);
                LOGGER.debug("Downloading Again :: sourcefile :: " + sourceFile);
                return this.getHttpResponse(sourceFile, destinationFile, counter, proxydetails, headers, isBinary, status, new SSLValidationType[0]);
            }
        }
        return status;
    }

    public Collection<? extends Header> getDefaultHeaders() {
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        BasicHeader clearCache = new BasicHeader("Cache-Control", (Object)"no-cache");
        BasicHeader acceptHeader = new BasicHeader("Accept", (Object)"*/*");
        defaultHeaders.add(clearCache);
        defaultHeaders.add(acceptHeader);
        return defaultHeaders;
    }

    public SSLContext getSSLContext() {
        SSLContext sslContext = null;
        try {
            TrustManager[] trustAllCertificates = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCertificates, new SecureRandom());
        }
        catch (Exception e) {
            LOGGER.debug("Exception Occured::::   " + e.getMessage());
        }
        return sslContext;
    }

    private void setHeadersData(Properties headersData, HttpGet request) {
        int size;
        if (headersData != null && (size = headersData.size()) > 0) {
            Enumeration<Object> iterate = headersData.keys();
            while (iterate.hasMoreElements()) {
                String key = (String)iterate.nextElement();
                String value = (String)headersData.get(key);
                request.setHeader(key, (Object)value);
            }
        }
    }

    public CloseableHttpClient getConnection(String connectionUrl, Properties proxyConf, boolean validate) throws Exception {
        HashMap<String, Object> proxyDetails = this.getProxyDetails(proxyConf);
        HttpHost proxy = (HttpHost)proxyDetails.get("proxy");
        BasicCredentialsProvider credentialsProvider = (BasicCredentialsProvider)proxyDetails.get("credentialsProvider");
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(true).setCookieSpec("ignore").setConnectionRequestTimeout(Timeout.ofMilliseconds((long)connectionTimeOut)).setResponseTimeout(Timeout.ofMilliseconds((long)connectionTimeOut)).build();
        if (!validate) {
            LOGGER.info("Validation not required for url :: " + connectionUrl);
            return HttpClients.custom().setDefaultHeaders(this.getDefaultHeaders()).setDefaultRequestConfig(requestConfig).setProxy(proxy).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        }
        return HttpClients.custom().setDefaultHeaders(this.getDefaultHeaders()).setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(this.getSSLContext()).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build()).build()).setDefaultRequestConfig(requestConfig).setProxy(proxy).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    private HashMap<String, Object> getProxyDetails(Properties proxyConf) throws Exception {
        String proxyHost = null;
        String proxyPort = null;
        String userName = null;
        String password = null;
        HashMap<String, Object> proxyDetails = new HashMap<String, Object>();
        if (proxyConf != null) {
            proxyHost = (String)proxyConf.get("proxyHost");
            proxyPort = (String)proxyConf.get("proxyPort");
            userName = (String)proxyConf.get("proxyUser");
            password = (String)proxyConf.get("proxyPass");
        }
        HttpHost proxy = null;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (proxyHost != null && proxyPort != null && !proxyHost.isEmpty() && !proxyPort.isEmpty()) {
            proxy = new HttpHost(this.proxyProtocol, proxyHost, Integer.parseInt(proxyPort));
        }
        if (proxy != null) {
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(userName, password.toCharArray()));
        }
        proxyDetails.put("proxy", proxy);
        proxyDetails.put("credentialsProvider", credentialsProvider);
        return proxyDetails;
    }

    private List<SSLValidationType> getDownloadManagerDefaultSSLValidations(String theUrl) {
        ArrayList<SSLValidationType> sslValidationTypes = new ArrayList<SSLValidationType>();
        try {
            URL url = new URL(theUrl);
            String requestDomain = url.getHost();
            String requestProtocol = url.getProtocol();
            for (String domainName : enforceHttpsList) {
                if (!domainName.equalsIgnoreCase(requestDomain) || !requestProtocol.equalsIgnoreCase("http")) continue;
                sslValidationTypes.add(SSLValidationType.ENFORCE_HTTPS);
            }
            for (String domainName : defaultSSLValidationDomainList) {
                if (!domainName.equalsIgnoreCase(requestDomain)) continue;
                sslValidationTypes.add(SSLValidationType.DEFAULT_SSL_VALIDATION);
            }
            if (requestProtocol.equalsIgnoreCase("https") && !sslValidationTypes.contains((Object)SSLValidationType.DEFAULT_SSL_VALIDATION)) {
                sslValidationTypes.add(SSLValidationType.DEFAULT_SSL_VALIDATION);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return sslValidationTypes;
    }

    public void addEnforceHttpsDomainList(String ... domains) throws IllegalArgumentException {
        for (String domainName : domains) {
            if (domainName == null || domainName.trim().length() <= 0) {
                throw new IllegalArgumentException("Domain name cannot be null/empty.");
            }
            enforceHttpsList.add(domainName);
        }
    }

    public void addDefaultSSLValidationDomainList(String ... domains) throws IllegalArgumentException {
        for (String domainName : domains) {
            if (domainName == null || domainName.trim().length() <= 0) {
                throw new IllegalArgumentException("Domain name cannot be null/empty.");
            }
            defaultSSLValidationDomainList.add(domainName);
        }
    }

    public DownloadStatus downloadFileWithCheckSumValidation(String sourceFile, String destinationFile, String checkSum, String checksumType, Properties formData, Properties headers, SSLValidationType ... validationTypes) {
        checksumValidationFile = 1;
        long size = 0L;
        int retryCount = 3;
        boolean downloadRetryFlag = true;
        DownloadStatus downloadStatus = this.downloadFile(sourceFile, destinationFile);
        while (downloadRetryFlag && retryCount > 0) {
            try {
                if (downloadStatus.getStatus() != 0) {
                    LOGGER.log(Level.INFO, "Download failed: " + downloadStatus.getStatus() + " message: " + downloadStatus.getErrorMessage());
                    LOGGER.log(Level.INFO, "Retry download will continue in 3 seconds, Available Retries: " + --retryCount);
                    Thread.sleep(3000L);
                    downloadStatus = this.downloadFile(sourceFile, destinationFile);
                    continue;
                }
                if (downloadStatus.getStatus() != 0 || checkSum == null) continue;
                boolean checkSumSuccess = ChecksumProvider.getInstance().ValidateFileCheckSum(destinationFile, checkSum, checksumType, Boolean.TRUE);
                if (!checkSumSuccess) {
                    downloadStatus.setStatus(10009);
                    LOGGER.error("Checksumvalidationfailed for " + sourceFile);
                    new File(destinationFile).delete();
                    if (!new File(destinationFile).exists()) {
                        LOGGER.debug("Chech sum validation failed file " + destinationFile + " is deleted");
                        LOGGER.log(Level.INFO, "Retry download will continue in 3 seconds, Available Retries: " + --retryCount);
                        Thread.sleep(3000L);
                        downloadStatus = this.downloadFile(sourceFile, destinationFile);
                        continue;
                    }
                    LOGGER.debug("Error occured while deleting the file");
                    continue;
                }
                downloadRetryFlag = false;
            }
            catch (Exception e) {
                LOGGER.error("Download failed for " + sourceFile + " :  " + e.getMessage());
                --retryCount;
            }
        }
        if (new File(destinationFile).exists()) {
            size = new File(destinationFile).length();
        }
        STATUS_LOGGER.info(String.format("%10d %20d %5s %s", downloadStatus.getStatus(), size, " ", sourceFile));
        checksumValidationFile = 0;
        return downloadStatus;
    }
}

