/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.downloadutils;

import com.adventnet.downloadutils.DownloadManager;
import com.adventnet.downloadutils.DownloadStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomResponseHandler
implements HttpClientResponseHandler {
    private static final Logger LOGGER = LogManager.getLogger(DownloadManager.class);
    String sourceFile;
    String destinationFile;
    boolean isBinary;
    DownloadStatus status;

    public CustomResponseHandler(String sourceFile, String destinationFile, boolean isBinary, DownloadStatus status) {
        this.sourceFile = sourceFile;
        this.destinationFile = destinationFile;
        this.isBinary = isBinary;
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
        block27: {
            InputStream in = null;
            boolean continueDownload = true;
            try {
                if (response != null) {
                    int httpstatus = response.getCode();
                    if (httpstatus >= 200 && httpstatus < 400) {
                        String rspContentType;
                        if (this.isBinary && (rspContentType = response.getHeader("Content-Type").getValue()) != null && rspContentType.indexOf("text/") != -1) {
                            continueDownload = false;
                        }
                        if (!continueDownload) break block27;
                        in = response.getEntity().getContent();
                        LOGGER.debug("Reading the stream of the url ..." + this.sourceFile);
                        String contentLength = response.getHeader("Content-Length") != null ? response.getHeader("Content-Length").getValue() : null;
                        try {
                            if (in != null) {
                                for (int loopCounter = 0; in.available() < 1 && loopCounter < 6 && (contentLength == null || Long.parseLong(contentLength) <= 0L); ++loopCounter) {
                                    Thread.sleep(10000L);
                                }
                            }
                        }
                        catch (InterruptedException iex) {
                            LOGGER.debug("The Patch Download thread in sleep exception : " + iex.getMessage());
                            LOGGER.debug("Exception : ", (Throwable)iex);
                        }
                        if (in != null && in.available() > 0) {
                            if (this.destinationFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)in, (File)new File(this.destinationFile));
                                this.status.dwnloadstatus = 0;
                            }
                        } else if (contentLength != null && Long.parseLong(contentLength) > 0L) {
                            if (this.destinationFile != null) {
                                FileUtils.copyInputStreamToFile((InputStream)in, (File)new File(this.destinationFile));
                                this.status.dwnloadstatus = 0;
                            }
                        } else {
                            LOGGER.debug("The in stream is empty for the url" + this.sourceFile);
                        }
                        break block27;
                    }
                    if (httpstatus == 403) {
                        this.status.dwnloadstatus = httpstatus;
                        this.status.errMessage = "The request is forbidden.Http Status Code :: 403";
                    } else if (httpstatus == 407) {
                        this.status.dwnloadstatus = httpstatus;
                        this.status.errMessage = "Download blocked by firewall/antivirus .Http Status Code :: 407";
                    } else if (httpstatus == 503) {
                        this.status.dwnloadstatus = httpstatus;
                        this.status.errMessage = "Unable to download binary, the specific vendors website is not responding. Retry after some time .Http Status Code :: 503";
                    } else {
                        this.status.dwnloadstatus = httpstatus;
                        LOGGER.debug("The http status code returned from web server : " + httpstatus);
                        this.status.errMessage = "The http status code returned from web server : " + httpstatus;
                    }
                    break block27;
                }
                LOGGER.debug("The received response is null for the source url : " + this.sourceFile);
                this.status.errMessage = "The received response is null for the source url : " + this.sourceFile;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    LOGGER.debug("Error while closing input streams :" + ex);
                }
            }
        }
        return true;
    }
}

