/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.downloadutils;

import com.adventnet.downloadutils.DownloadManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChecksumProvider {
    private static final Logger LOGGER = LogManager.getLogger(DownloadManager.class);
    private static String encryptionKey = "encryption_algorithms";
    public static final String DEFAULT_ALGORITHM = "SHA-256";
    private static String algorithm1 = "security_algorithm1";
    private static String algorithm2 = "security_algorithm2";
    private static String security_algorithm1;
    private static String security_algorithm2;
    private static ChecksumProvider checksumProvider;

    public static String getSecurityAlgorithm1() {
        return security_algorithm1;
    }

    public static String getSecurityAlgorithm2() {
        return security_algorithm2;
    }

    public static synchronized ChecksumProvider getInstance() {
        if (checksumProvider == null) {
            checksumProvider = new ChecksumProvider();
        }
        return checksumProvider;
    }

    public String GetMD5hashFromString(String inputString) throws Exception {
        byte[] buffer = new byte[1024];
        String output = "";
        buffer = inputString.getBytes();
        int length = inputString.length();
        try {
            MessageDigest digest = MessageDigest.getInstance(security_algorithm1);
            digest.update(buffer, 0, length);
            byte[] md5sum = digest.digest();
            for (int i = 0; i < md5sum.length; ++i) {
                output = output + Integer.toString((md5sum[i] & 0xFF) + 256, 16).substring(1);
            }
            LOGGER.error("MD5 hash of the given string(" + inputString + ") is:  " + output);
        }
        catch (Exception exp) {
            LOGGER.error("Got Exception in GetMD5hashFromString(): " + exp);
            output = "--";
        }
        return output;
    }

    public String GetMD5HashFromFile(String filePath) throws Exception {
        return this.GetMD5HashFromFile(filePath, false);
    }

    public String GetMD5HashFromFile(String filePath, boolean isStaticFile) throws Exception {
        String output = "";
        try (FileInputStream input = null;){
            input = new FileInputStream(filePath);
            output = this.getMD5HashFromInputStream(input);
            LOGGER.error("MD5 hash of the given file(" + filePath + ") is:  " + output);
        }
        return output;
    }

    public String getMD5HashFromInputStream(InputStream input) throws Exception {
        byte[] buffer = new byte[8192];
        int read = 0;
        String output = "";
        try {
            MessageDigest digest = MessageDigest.getInstance(security_algorithm1);
            while ((read = input.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            for (int i = 0; i < md5sum.length; ++i) {
                output = output + Integer.toString((md5sum[i] & 0xFF) + 256, 16).substring(1);
            }
        }
        catch (Exception exp) {
            LOGGER.error("Got Exception in getMD5HashFromInputStream(): " + exp);
            output = "--";
            throw exp;
        }
        return output;
    }

    public boolean ValidateFileCheckSum(String filePath, String checksumToCompare) throws Exception {
        return this.ValidateFileCheckSum(filePath, checksumToCompare, Boolean.FALSE);
    }

    public boolean ValidateFileCheckSum(String filePath, String checksumToCompare, boolean isLocal) throws Exception {
        String fileCheckSum = "";
        fileCheckSum = this.GetMD5HashFromFile(filePath, isLocal);
        if (fileCheckSum.length() > 31) {
            if (fileCheckSum.compareTo(checksumToCompare) == 0) {
                return true;
            }
            LOGGER.error("checkSum failed for filePath ::" + filePath + " as downloaded file's checksum ::" + fileCheckSum + " is different from checksum in db ::" + checksumToCompare);
            return false;
        }
        return false;
    }

    public boolean ValidateSHA256CheckSum(String filePath, String sha256CheckSumToCompare) {
        return this.ValidateSHA256CheckSum(filePath, sha256CheckSumToCompare, Boolean.FALSE);
    }

    public boolean ValidateSHA256CheckSum(String filePath, String sha256CheckSumToCompare, boolean isLocal) {
        String fileCheckSum = "";
        Boolean isValid = Boolean.FALSE;
        fileCheckSum = this.GetSHA256CheckSum(filePath, isLocal);
        if (fileCheckSum.length() == 64) {
            if (fileCheckSum.equalsIgnoreCase(sha256CheckSumToCompare)) {
                isValid = Boolean.TRUE;
            } else {
                LOGGER.error("SHA 256 checkSum failed for FilePath ::" + filePath + " as the downloaded file's checksum ::" + fileCheckSum + " is different from checksum in db ::" + sha256CheckSumToCompare);
            }
        } else {
            LOGGER.error("SHA 256 checkSum failed for FilePath ::" + filePath + " as the downloaded file's checksum ::" + fileCheckSum + " has greater or lesser than 64 digits");
        }
        return isValid;
    }

    public String GetSHA256CheckSum(String filePath) {
        return this.GetSHA256CheckSum(filePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String GetSHA256CheckSum(String filePath, Boolean isStaticFile) {
        String Checksum = "";
        InputStream fis = null;
        try {
            StringBuilder sb = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(DEFAULT_ALGORITHM);
            fis = new FileInputStream(filePath);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            Checksum = sb.toString();
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex);
            }
        }
        return Checksum;
    }

    public boolean validateSHA1CheckSum(String filePath, String sha1CheckSumToCompare) {
        return this.validateSHA1CheckSum(filePath, sha1CheckSumToCompare, Boolean.FALSE);
    }

    public boolean validateSHA1CheckSum(String filePath, String sha1CheckSumToCompare, boolean isLocal) {
        String fileCheckSum = "";
        Boolean isValid = Boolean.FALSE;
        fileCheckSum = this.getSHA1CheckSum(filePath);
        if (fileCheckSum.length() == 40) {
            if (fileCheckSum.equalsIgnoreCase(sha1CheckSumToCompare)) {
                isValid = Boolean.TRUE;
            } else {
                LOGGER.error("SHA 1 checkSum failed for FilePath ::" + filePath + " as the downloaded file's checksum ::" + fileCheckSum + " is different from checksum in db ::" + sha1CheckSumToCompare);
            }
        } else {
            LOGGER.error("SHA 1 checkSum failed for FilePath ::" + filePath + " as the downloaded file's checksum ::" + fileCheckSum + " has greater or lesser than 40 digits");
        }
        return isValid;
    }

    public String getSHA1CheckSum(String filePath) {
        return this.getSHA1CheckSum(filePath, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSHA1CheckSum(String filePath, boolean isStaticFile) {
        String Checksum = "";
        InputStream fis = null;
        try {
            StringBuilder sb = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance(security_algorithm2);
            fis = new FileInputStream(filePath);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            Checksum = sb.toString();
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex);
            }
        }
        return Checksum;
    }

    public boolean ValidateFileCheckSum(String filePath, String checksumToCompare, String checkSumType) throws Exception {
        return this.ValidateFileCheckSum(filePath, checksumToCompare, checkSumType, Boolean.FALSE);
    }

    public boolean ValidateFileCheckSum(String filePath, String checksumToCompare, String checkSumType, boolean isLocal) throws Exception {
        boolean isCheckSumValidationSuccess = false;
        if (checkSumType.equalsIgnoreCase(security_algorithm1)) {
            isCheckSumValidationSuccess = this.ValidateFileCheckSum(filePath, checksumToCompare, isLocal);
        } else if (checkSumType.equalsIgnoreCase("SHA256")) {
            isCheckSumValidationSuccess = this.ValidateSHA256CheckSum(filePath, checksumToCompare, isLocal);
        } else if (checkSumType.equalsIgnoreCase(security_algorithm2.replaceAll("-", ""))) {
            isCheckSumValidationSuccess = this.validateSHA1CheckSum(filePath, checksumToCompare, isLocal);
        }
        return isCheckSumValidationSuccess;
    }

    static {
        checksumProvider = null;
        try {
            security_algorithm1 = "MD5";
            security_algorithm2 = "SHA1";
        }
        catch (Exception excep) {
            LOGGER.error(excep.getMessage());
        }
    }

    public static enum ChecksumType {
        SHA_256("SHA256"),
        MD5("MD5"),
        SHA1("SHA1");

        private String value;

        private ChecksumType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ChecksumType getChecksumType(String checksumType) {
            return ((Stream)Arrays.stream(ChecksumType.values()).parallel()).filter(type -> type.value.equals(checksumType)).findFirst().orElse(SHA_256);
        }
    }
}

