/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.cipher;

import cryptix.jce.provider.cipher.BlockCipher;
import cryptix.jce.provider.cipher.ModeCBC;
import cryptix.jce.provider.cipher.ModeCFB;
import cryptix.jce.provider.cipher.ModeECB;
import cryptix.jce.provider.cipher.ModeOFB;
import cryptix.jce.provider.cipher.ModeOpenpgpCFB;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

abstract class Mode {
    protected final BlockCipher cipher;
    protected final int CIPHER_BLOCK_SIZE;
    protected boolean decrypt;
    protected int bufCount;

    Mode(BlockCipher cipher) {
        this.cipher = cipher;
        this.CIPHER_BLOCK_SIZE = cipher.coreGetBlockSize();
    }

    abstract byte[] coreGetIV();

    abstract int coreGetOutputSize(int var1);

    abstract AlgorithmParameterSpec coreGetParamSpec();

    abstract void coreInit(boolean var1, Key var2, AlgorithmParameterSpec var3, SecureRandom var4) throws InvalidKeyException, InvalidAlgorithmParameterException;

    abstract int coreUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected final byte[] extractIV(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params instanceof IvParameterSpec) {
            return ((IvParameterSpec)params).getIV();
        }
        if (params instanceof RC2ParameterSpec) {
            return ((RC2ParameterSpec)params).getIV();
        }
        if (params instanceof RC5ParameterSpec) {
            return ((RC5ParameterSpec)params).getIV();
        }
        throw new InvalidAlgorithmParameterException("Don't know how to get an IV from a " + params.getClass().getName());
    }

    protected byte[] generateIV() {
        byte[] b = new byte[this.CIPHER_BLOCK_SIZE];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return b;
    }

    final int getBlockSize() {
        return this.CIPHER_BLOCK_SIZE;
    }

    final int getBufSize() {
        return this.bufCount;
    }

    final byte[] getIV() {
        return this.coreGetIV();
    }

    static Mode getInstance(String mode, BlockCipher cipher) throws NoSuchAlgorithmException {
        try {
            if (mode.equalsIgnoreCase("CBC")) {
                return new ModeCBC(cipher);
            }
            if (mode.substring(0, 3).equalsIgnoreCase("CFB")) {
                String fbs = mode.substring(3, mode.length());
                if (fbs.length() > 0) {
                    return new ModeCFB(cipher, Integer.parseInt(fbs));
                }
                return new ModeCFB(cipher);
            }
            if (mode.equalsIgnoreCase("ECB")) {
                return new ModeECB(cipher);
            }
            if (mode.equalsIgnoreCase("OFB")) {
                return new ModeOFB(cipher);
            }
            if (mode.equalsIgnoreCase("openpgpCFB")) {
                return new ModeOpenpgpCFB(cipher);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new NoSuchAlgorithmException("Mode (" + mode + ") not available.");
    }

    final int getOutputSize(int inputLen) {
        return this.coreGetOutputSize(inputLen);
    }

    final AlgorithmParameterSpec getParamSpec() {
        return this.coreGetParamSpec();
    }

    void init(boolean decrypt, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.decrypt = decrypt;
        this.coreInit(decrypt, key, params, random);
    }

    abstract boolean needsPadding();

    final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        return this.coreUpdate(input, inputOffset, inputLen, output, outputOffset);
    }
}

