/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.asn;

import cryptix.jce.provider.asn.AsnOutputStream;
import java.io.IOException;

public abstract class AsnObject {
    static final byte TAG_MASK = 31;
    static final byte TAG_INTEGER = 2;
    static final byte TAG_BITSTRING = 3;
    static final byte TAG_NULL = 5;
    static final byte TAG_OBJECT_ID = 6;
    static final byte TAG_SEQUENCE = 48;
    static final byte TAG_SET = 49;
    static final byte TAG_PRINTABLE_STRING = 19;
    static final byte TAG_UTCTime = 23;
    private final byte tag;

    protected AsnObject(byte tag) {
        this.tag = tag;
    }

    final void encode(AsnOutputStream os) throws IOException {
        os.writeType(this.tag);
        os.writeLength(this.getEncodedLengthOfPayload(os));
        this.encodePayload(os);
    }

    protected abstract void encodePayload(AsnOutputStream var1) throws IOException;

    public final boolean equals(Object o) {
        throw new RuntimeException("AsnObject.equals(...) not implemented.");
    }

    final int getEncodedLength(AsnOutputStream os) {
        int len = this.getEncodedLengthOfPayload(os);
        len += os.getLengthOfLength(len);
        return ++len;
    }

    protected abstract int getEncodedLengthOfPayload(AsnOutputStream var1);

    final byte getTag() {
        return this.tag;
    }

    public final int hashCode() {
        throw new RuntimeException("AsnObject.hashCode(...) not implemented.");
    }

    public final String toString() {
        return this.toString("");
    }

    public abstract String toString(String var1);
}

